// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Log/hkLog.h>
#include <Common/Visualize/hkVisualDebuggerCmdType.h>

#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCmdHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbDisplayHandler.h>

class hkVdbSetupHandler;

//////////////////////////////////////////////////////////////////////////
/// A handler for text-related cmds.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbTextHandler : public hkVdbCmdHandler<hkVdbCmdHandlerType::TEXT>
{
public:
    HK_DECLARE_CLASS( hkVdbTextHandler, New );
    hkVdbTextHandler();

    //
    // hkVdbCmdHandler interface.
    //

    virtual hkResult registerSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult unregisterSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) HK_OVERRIDE;

    //
    // Signals
    //

    
    /// Info about text from a vdb cmd.
    struct TextInfo
    {
        HK_DECLARE_CLASS( TextInfo, New );

        /// The id associated with the text.
        hkUint64 m_id;

        /// The tag (usually from process/viewer) associated with the text.
        int m_tag;

        /// The log level of the text (Eg. Info, Warning, Error).
        hkLog::Level::Enum m_level;

        /// The text.
        const char* m_text;
    };

    HK_DECLARE_SIGNAL( TextInfoReceivedSignal, hkSignal2< const TextInfo&, hkVdbSignalResult& > );
    /// Fired when text info is received from a server.
    TextInfoReceivedSignal m_textInfoReceived;
    

    //
    // Internal use
    //

    void onDisplayCmdReceivedSignal( const hkVdbDisplayHandler::DisplayCmd& displayCmd, hkVdbSignalResult& result );
    hkResult processTextInfoCmd( hkVdbCmdType::Enum type, int protocol, hkVdbLocalIStream& dataReader );

protected:

    // Avoid allocations during dispatch by having these declared and just reusing them
    TextInfo m_textInfo;

    hkRefPtr<hkVdbCmdInput> m_input;
    hkRefPtr<hkVdbSetupHandler> m_setupHandler;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
