// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbTextHandler.h>

#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/Command/hkVdbCmdInput.h>
#include <VisualDebugger/VdbServices/System/Command/hkVdbCmdDispatcher.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbSetupHandler.h>

#define DEBUG_LOG_IDENTIFIER "vdb.Cmd.Handler.Text"
#include <Common/Base/System/Log/hkLog.hxx>

#define READ_ID_FIRST( _ID, _STREAM, _BITS ) \
    if ( protocol >= hkProtocolVersion::SUPPORTS_CIRCULAR_BUFFER ) { _ID = _STREAM.read##_BITS(); } HK_MUST_END_WITH_SEMICOLON
#define READ_ID_LATER( _ID, _STREAM, _BITS ) \
    if ( protocol < hkProtocolVersion::SUPPORTS_CIRCULAR_BUFFER ) { _ID = _STREAM.read##_BITS(); } HK_MUST_END_WITH_SEMICOLON

namespace
{
    hkResult handleTextInfoCmdFunc( const hkVdbFrame& frame, const hkVdbCmd& cmd, int protocol, hkVdbLocalIStream& dataReader, hkVdbProcessInfo* processInfo, void* userHandle )
    {
        hkVdbTextHandler* handler = reinterpret_cast< hkVdbTextHandler* >( userHandle );
        return handler->processTextInfoCmd( cmd.getType(), protocol, dataReader );
    }
};

hkVdbTextHandler::hkVdbTextHandler() :
    hkVdbCmdHandler<hkVdbCmdHandlerType::TEXT>( &s_debugLog )
{}

hkResult hkVdbTextHandler::registerSelf( hkVdbClient& client )
{
    using namespace hkVdbCmdType;

    bool succeeded = true;
    hkVdbCmdDispatcher& dispatcher = client.getCmdDispatcher();

    succeeded &= ( dispatcher.registerHandler( LOG_TEXT, handleTextInfoCmdFunc, this, this ).isSuccess() );

    m_input = &client.getCmdInput();
    m_setupHandler = client.getCmdHandler<hkVdbSetupHandler>();

    HK_SUBSCRIBE_TO_SIGNAL( client.getCmdHandler<hkVdbDisplayHandler>()->m_displayCmdReceived, this, hkVdbTextHandler );

    HK_VDB_VERIFY_REPORTER_CONDITION( succeeded, dispatcher, hkVdbError::CMD_HANDLER_REGISTRATION_ERROR );

    return HK_SUCCESS;
}

hkResult hkVdbTextHandler::unregisterSelf( hkVdbClient& client )
{
    using namespace hkVdbCmdType;

    bool succeeded = true;
    hkVdbCmdDispatcher& dispatcher = client.getCmdDispatcher();

    succeeded &= ( dispatcher.unregisterHandler( LOG_TEXT ).isSuccess() );

    client.getCmdHandler<hkVdbDisplayHandler>()->m_displayCmdReceived.unsubscribeAll( this );

    m_input = HK_NULL;
    m_setupHandler = HK_NULL;

    HK_VDB_VERIFY_REPORTER_CONDITION( succeeded, dispatcher, hkVdbError::CMD_HANDLER_REGISTRATION_ERROR );

    return HK_SUCCESS;
}

void hkVdbTextHandler::onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) {}

void hkVdbTextHandler::onDisplayCmdReceivedSignal( const hkVdbDisplayHandler::DisplayCmd& displayCmd, hkVdbSignalResult& result )
{
    // Before 16300, the display handler text was expected to be sent to the vdb log window.
    // We now have hkServerTextHandler which used the LOG_TEXT cmd to distinguish between log text
    // and display text.
    if ( m_setupHandler->getServerProtocol() < hkProtocolVersion::VDB_2017_1 )
    {
        if ( const hkVdbDisplayHandler::DisplayTextCmd* displayTextCmd = displayCmd.asTextCmd() )
        {
            m_textInfo.m_id = displayTextCmd->m_id;
            m_textInfo.m_level = hkLog::Level::Info;
            m_textInfo.m_text = displayTextCmd->m_text;
            m_textInfo.m_tag = displayTextCmd->m_tag;
            m_textInfoReceived.fire( m_textInfo, result );
        }
    }
}

hkResult hkVdbTextHandler::processTextInfoCmd( hkVdbCmdType::Enum type, int protocol, hkVdbLocalIStream& dataReader )
{
    using namespace hkVdbCmdType;

    hkStringBuf buf;
    m_textInfo.m_id = dataReader.read64u();
    m_textInfo.m_level = hkLog::Level::Enum( dataReader.read8u() );
    dataReader.readString( buf );
    m_textInfo.m_text = buf;
    m_textInfo.m_tag = dataReader.read32();

    HK_VDB_VERIFY_CONDITION( dataReader.isOk(), 0xedb00108, hkVdbError::CMD_HANDLER_READ_ERROR );

    // Signal
    hkVdbSignalResult result;
    m_textInfoReceived.fire( m_textInfo, result );
    HK_VDB_VERIFY_SIGNAL_RESULT( result );

    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
