// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkVisualDebuggerCmdType.h>
#include <Common/Visualize/hkVersionReporter.h>

#include <VisualDebugger/VdbServices/System/hkVdbCapabilities.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCmdHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbProcessHandler.h>

class hkVdbCmdOutput;

//////////////////////////////////////////////////////////////////////////
/// A handler for setup-related cmds.
/// This handler provides a lot of information about the server and client.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbSetupHandler : public hkVdbCmdHandler<hkVdbCmdHandlerType::SETUP>
{
public:
    HK_DECLARE_CLASS( hkVdbSetupHandler, New );
    hkVdbSetupHandler();

    //
    // hkVdbCmdHandler interface.
    //

    virtual hkResult registerSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult unregisterSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) HK_OVERRIDE;

    //
    // Query
    //

    
    typedef hkVersionReporter::Info ClientInfo;
    /// Get setup/version information about the client.
    void getClientInfo( ClientInfo& clientInfoOut ) const { clientInfoOut = m_clientInfo; }

    /// Get the client's protocol version.
    int getClientProtocol() const { return m_clientInfo.m_protocol; }

    typedef hkVersionReporter::Info ServerInfo;
    /// Get setup/version information about the server.
    hkResult getServerInfo( ServerInfo& serverInfoOut ) const;

    /// Get the server's protocol version.
    int getServerProtocol() const;

    /// Returns true if the server/client combo is capable of the provided capabilities.
    /// This is only valid after we've received information about our server.
    hkBool32 isCapableOf( hkVdbCapabilities capability ) const
    {
        HK_ASSERT(
            0x22441318,
            ( capability == hkVdbCapabilities::UNKNOWN ) || m_capabilities.noneIsSet( hkVdbCapabilities::UNKNOWN ),
            "We do not yet know our capabilities" );
        return m_capabilities.allAreSet( capability );
    }
    

    //
    // Signals
    //

    
    HK_DECLARE_SIGNAL( ServerInfoReceivedSignal, hkSignal4< const ClientInfo&, const ServerInfo&, hkVdbCapabilities, hkVdbSignalResult& > );
    /// Fired when we receive information about the server or its capabilities change.
    ServerInfoReceivedSignal m_serverInfoReceived;
    

    //
    // Internal use
    //

    void onProcessCmdReceivedSignal( const hkVdbProcessHandler::ProcessCmd& processCmd, hkVdbSignalResult& result );
    hkResult processServerInfoCmd( hkVdbCmdType::Enum type, int protocol, hkVdbLocalIStream& dataReader );

protected:

    // Update the capabilities and return results if signaling was requested.
    hkVdbSignalResult updateCapabilities( hkVdbCapabilities capabilities, hkBool32 init, hkBool32 signal );

    // Avoid allocations during dispatch by having these declared and just reusing them
    ClientInfo m_clientInfo;
    ServerInfo m_serverInfo;
    // This is the current capabilities.
    hkVdbCapabilities m_capabilities;
    // This is the capabilities as understood from the client/server's raw capabilities (aka not limited by any processes).
    hkVdbCapabilities m_baseCapabilities;
    // A count of the current processes which are limiting the capabilities.
    // ATM, we restrict *all* capabilities for particular viewers. As capabilities grow and/or
    // we have viewers which limit only a subset of capabilities, this all-or-nothing approach
    // to limiting capabilities will be insufficient (see onProcessCmdReceivedSignal)
    int m_numProcessesRestrictingCapabilities;

    hkRefPtr<hkVdbCmdOutput> m_output;
    hkRefPtr<hkVdbProcessHandler> m_processHandler;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
