// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE const hkVdbProcessHandler::ProcessRegisteredCmd* hkVdbProcessHandler::ProcessCmd::asRegisteredCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440899, m_cmdType != INVALID, "Cmd type was not set" );

    if ( ( m_cmdType == REGISTER_PROCESS ) ||
        ( m_cmdType == REGISTER_PROCESS_EX ) )
    {
        return reinterpret_cast< const ProcessRegisteredCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbProcessHandler::ProcessUpdatedCmd* hkVdbProcessHandler::ProcessCmd::asUpdatedCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440900, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == TWEAK_PROCESS )
    {
        return reinterpret_cast< const ProcessUpdatedCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbProcessHandler::ProcessSelectionChangedCmd* hkVdbProcessHandler::ProcessCmd::asSelectionChangedCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440901, m_cmdType != INVALID, "Cmd type was not set" );

    if ( ( m_cmdType == SELECT_PROCESS ) ||
        ( m_cmdType == UNSELECT_PROCESS ) )
    {
        return reinterpret_cast< const ProcessSelectionChangedCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbProcessHandler::ProcessRegisteredCmd::Ex* hkVdbProcessHandler::ProcessRegisteredCmd::getExtended() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440902, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == REGISTER_PROCESS_EX )
    {
        return &m_extended;
    }

    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
