// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE const hkVdbObjectHandler::ObjectsAddedCmd* hkVdbObjectHandler::ObjectsCmd::asObjectsAddedCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441135, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == ADD_OBJECTS )
    {
        return reinterpret_cast< const ObjectsAddedCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbObjectHandler::ObjectsUpdatedCmd* hkVdbObjectHandler::ObjectsCmd::asObjectsUpdatedCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441136, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == UPDATE_OBJECTS )
    {
        return reinterpret_cast< const ObjectsUpdatedCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbObjectHandler::ObjectsRemovedCmd* hkVdbObjectHandler::ObjectsCmd::asObjectsRemovedCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441137, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == REMOVE_OBJECTS )
    {
        return reinterpret_cast< const ObjectsRemovedCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbObjectHandler::DisposeObjectsCmd* hkVdbObjectHandler::ObjectsCmd::asDisposeObjectsCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441217, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == CLIENT_INTERNAL )
    {
        return reinterpret_cast< const DisposeObjectsCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbObjectHandler::ConnectIdsCmd* hkVdbObjectHandler::ConnectivityCmd::asConnectIdsCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441138, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == CONNECT_OBJECTS )
    {
        return reinterpret_cast< const ConnectIdsCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbObjectHandler::DisconnectIdsCmd* hkVdbObjectHandler::ConnectivityCmd::asDisconnectIdsCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441139, m_cmdType != INVALID, "Cmd type was not set" );

    if ( ( m_cmdType == DISCONNECT_OBJECTS ) && ( m_ids.getSize() != 0 ) )
    {
        return reinterpret_cast< const DisconnectIdsCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbObjectHandler::SetConnectionIdsCmd* hkVdbObjectHandler::ConnectivityCmd::asSetConnectionIdsCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441140, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == CUSTOM )
    {
        return reinterpret_cast< const SetConnectionIdsCmd* >( this );
    }

    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
