// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServices/System/Command/hkVdbCmd.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCmdHandler.h>

struct hkVdbFrame;
struct hkVdbCmd;
class hkVdbCmdDispatcher;
class hkVdbStatsHandler;
class hkVdbObjectHandler;
class hkVdbPlaybackHandler;
class hkPersistableReadFormat;

//////////////////////////////////////////////////////////////////////////
/// For advanced use only.
/// A handler for internal cmds. Internal cmds are placed into the server stream
/// by the client not the server. They are effectively implementation cmds
/// for client -> client (later when reloading).
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbInternalHandler : public hkVdbCmdHandler<hkVdbCmdHandlerType::INVALID>
{
public:
    HK_DECLARE_CLASS( hkVdbInternalHandler, New );
    hkVdbInternalHandler();

    //
    // hkVdbCmdHandler interface
    //

    virtual hkResult registerSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult unregisterSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) HK_OVERRIDE;

    //
    // Cmd serialization
    //

    static hkResult writeDispatchCmd( hkStreamWriter& writer, const hkVdbCmd& cmd, int protocol );
    static hkResult readDispatchCmd( const hkVdbCmd& cmd, int protocol, hkArray<hkInt8>& cmdBufferOut, int& protocolOut );
    static hkResult writeDebugTagCmd( hkStreamWriter& writer, int protocol, const char* tag );
    static hkResult readDebugTagCmd( const hkVdbCmd& cmd, int protocol, hkStringBuf& bufOut );
    static hkResult inplaceModifyStreamDebugTag( hkVdbCmd& cmd, int protocol );
    static hkResult writeUnpersistReadFormatCmd( hkStreamWriter& writer, int protocol, const hkArray<hkInt8>& persistentState, hkVdbCmdHandlerType::Enum handlerType );
    static hkResult readUnpersistReadFormatCmd( const hkVdbCmd& cmd, int protocol, hkArray<hkInt8>& persistentStateOut, hkVdbCmdHandlerType::Enum& handlerTypeOut );
    static hkResult writeMetaData( hkStreamWriter& writer, hkInt16 cmdIdx );

    //
    // Internal use
    //

    hkResult processInternalCmd(
        const hkVdbFrame& frame,
        const hkVdbCmd& cmd,
        int protocol,
        hkVdbLocalIStream& dataReader,
        hkVdbProcessInfo* processInfo );

protected:

    static hkResult skipAndVerifyHeader(
        const hkVdbCmd& cmd,
        int protocol,
        hkVdbLocalIStream& reader,
        hkVdbInternalCmdType::Enum expectedInternalType );

    hkRefPtr<hkVdbCmdDispatcher> m_dispatcher;
    hkRefPtr<hkVdbStatsHandler> m_statsHandler;
    hkRefPtr<hkVdbPlaybackHandler> m_playbackHandler;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
