// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkVisualDebuggerCmdType.h>

#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCmdHandler.h>

struct hkVdbCmd;
class hkVdbPlaybackHandler;

//////////////////////////////////////////////////////////////////////////
/// A handler for file-related cmds.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbFileHandler : public hkVdbCmdHandler<hkVdbCmdHandlerType::FILE>
{
public:
    HK_DECLARE_CLASS( hkVdbFileHandler, New );
    hkVdbFileHandler();

    //
    // hkVdbCmdHandler interface
    //

    virtual hkResult registerSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult unregisterSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) HK_OVERRIDE;

    //
    // Signals
    //

    
    /// Info describing a file to be written.
    struct FileInfo
    {
        HK_DECLARE_CLASS( FileInfo, New );
        FileInfo() : m_tag( 0 ) {}

        /// The tag (usually from process/viewer) associated with the file.
        int m_tag;

        /// A name for the type of file (Eg. "Havok Movie").
        const char* m_typeName;

        /// A list of allowed extensions for the file (the first being a default hint).
        hkArray<const char*> m_extensions;

        /// The file data blob.
        hkArray<hkInt8> m_data;
    };

    HK_DECLARE_SIGNAL( FileInfoReceivedSignal, hkSignal2< const FileInfo&, hkVdbSignalResult& > );
    /// Fired when a file has been received from the server.
    FileInfoReceivedSignal m_fileInfoReceived;
    

    //
    // Internal use
    //

    hkResult processFileInfoCmd( const hkVdbCmd& cmd, int protocol, hkVdbLocalIStream& dataReader );
    hkResult processDeprecatedSnapshotCmd( const hkVdbCmd& cmd, int protocol, hkVdbLocalIStream& dataReader );

protected:

    // Avoid allocations during dispatch by having these declared and just reusing them
    FileInfo m_fileInfo;

    hkRefPtr<hkVdbPlaybackHandler> m_playbackHandler;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
