// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE const hkVdbDisplayHandler::AddGeometryCmd* hkVdbDisplayHandler::GeometryCmd::asAddCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440877, m_cmdType != INVALID, "Cmd type was not set" );

    if (( m_cmdType == ADD_GEOMETRY ) ||
        ( m_cmdType == ADD_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_RIGID_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_ADD_RIGID_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_MORPHING_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_ADD_MORPHING_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_FIXED_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_ADD_FIXED_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_GEOMETRY_FINAL ) )
    {
        return reinterpret_cast< const AddGeometryCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::InstanceGeometryCmd* hkVdbDisplayHandler::GeometryCmd::asInstanceCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440878, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == INSTANCE_GEOMETRY )
    {
        return reinterpret_cast< const InstanceGeometryCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::UpdateGeometryCmd* hkVdbDisplayHandler::GeometryCmd::asUpdateCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440879, m_cmdType != INVALID, "Cmd type was not set" );

    if (( m_cmdType == UPDATE_GEOMETRY ) ||
        ( m_cmdType == UPDATE_GEOMETRY_TRANSFORM ) ||
        ( m_cmdType == UPDATE_GEOMETRY_TRANSFORM_EX ) ||
        ( m_cmdType == UPDATE_PARTICLE_TRANSFORMS) ||
        ( m_cmdType == UPDATE_GEOMETRY_VERTICES ) ||
        ( m_cmdType == SET_GEOMETRY_COLOR ) ||
        ( m_cmdType == SET_GEOMETRY_ALPHA ) ||
        ( m_cmdType == SET_GEOMETRY_FLAG_BITS ) ||
        ( m_cmdType == CLEAR_GEOMETRY_FLAG_BITS ) )
    {
        return reinterpret_cast< const UpdateGeometryCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::RemoveGeometryCmd* hkVdbDisplayHandler::GeometryCmd::asRemoveCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440880, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == REMOVE_GEOMETRY )
    {
        return reinterpret_cast< const RemoveGeometryCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::DisposeGeometryCmd* hkVdbDisplayHandler::GeometryCmd::asDisposeCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440880, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == CLIENT_INTERNAL )
    {
        return reinterpret_cast< const DisposeGeometryCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::AddGeometryCmd::Ex* hkVdbDisplayHandler::AddGeometryCmd::getExtended() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440881, m_cmdType != INVALID, "Cmd type was not set" );

    
    // Note: We force the deprecated geometry commands to have extended info even though no color was provided.
    // We simply use a default of LIGHTGREY. This is unfortunate, but there's no way around it...and it's deprecated.
    // It's unlikely to impact much because we used to set the color almost always.
    if (( m_cmdType == ADD_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_RIGID_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_ADD_RIGID_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_MORPHING_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_ADD_MORPHING_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_FIXED_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_ADD_FIXED_GEOMETRY_EX ) ||
        ( m_cmdType == DEPRECATED_ADD_GEOMETRY_FINAL ) )
    {
        return &m_extended;
    }

    return HK_NULL;
}

HK_INLINE const hkMatrix4* hkVdbDisplayHandler::UpdateGeometryCmd::getTransform() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440883, m_cmdType != INVALID, "Cmd type was not set" );

    if ((( m_cmdType == UPDATE_GEOMETRY ) && ( m_updateBits.anyIsSet( TRANSFORM ))) ||
        ( m_cmdType == UPDATE_GEOMETRY_TRANSFORM ) ||
        ( m_cmdType == UPDATE_GEOMETRY_TRANSFORM_EX ) )
    {
        return &m_transform;
    }

    return HK_NULL;
}

HK_INLINE const hkColor::Argb* hkVdbDisplayHandler::UpdateGeometryCmd::getColor() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440884, m_cmdType != INVALID, "Cmd type was not set" );

    if ((( m_cmdType == UPDATE_GEOMETRY ) && ( m_updateBits.anyIsSet( COLOR ))) ||
        ( m_cmdType == SET_GEOMETRY_COLOR ) )
    {
        return &m_color;
    }

    return HK_NULL;
}

HK_INLINE const hkReal* hkVdbDisplayHandler::UpdateGeometryCmd::getAlpha() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440885, m_cmdType != INVALID, "Cmd type was not set" );

    if ((( m_cmdType == UPDATE_GEOMETRY ) && ( m_updateBits.anyIsSet( ALPHA ))) ||
        ( m_cmdType == SET_GEOMETRY_ALPHA ) )
    {
        return &m_alpha;
    }

    return HK_NULL;
}

HK_INLINE const hkArray<hkVector4>* hkVdbDisplayHandler::UpdateGeometryCmd::getVerts() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440882, m_cmdType != INVALID, "Cmd type was not set" );

    if ((( m_cmdType == UPDATE_GEOMETRY ) && ( m_updateBits.anyIsSet( VERTS ))) ||
        ( m_cmdType == UPDATE_GEOMETRY_VERTICES ) )
    {
        return &m_newVertices;
    }

    return HK_NULL;
}

HK_INLINE const hkArray<hkTransform>* hkVdbDisplayHandler::UpdateGeometryCmd::getParticleTransforms() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440882, m_cmdType != INVALID, "Cmd type was not set" );

    if ( ((m_cmdType == UPDATE_GEOMETRY) && (m_updateBits.anyIsSet( PARTICLE_TRANSFORMS ))) ||
        (m_cmdType == UPDATE_PARTICLE_TRANSFORMS) )
    {
        return &m_newParticleTransforms;
    }

    return HK_NULL;
}

HK_INLINE const hkDisplayGeometryFlags* hkVdbDisplayHandler::UpdateGeometryCmd::getSetFlagBits() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440886, m_cmdType != INVALID, "Cmd type was not set" );

    if ((( m_cmdType == UPDATE_GEOMETRY ) && ( m_updateBits.anyIsSet( SET_FLAGS ))) ||
        ( m_cmdType == SET_GEOMETRY_FLAG_BITS ) )
    {
        return &m_setFlagBits;
    }

    return HK_NULL;
}

HK_INLINE const hkDisplayGeometryFlags* hkVdbDisplayHandler::UpdateGeometryCmd::getClearFlagBits() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440887, m_cmdType != INVALID, "Cmd type was not set" );

    if ((( m_cmdType == UPDATE_GEOMETRY ) && ( m_updateBits.anyIsSet( CLEAR_FLAGS ))) ||
        ( m_cmdType == CLEAR_GEOMETRY_FLAG_BITS ) )
    {
        return &m_clearFlagBits;
    }

    return HK_NULL;
}

HK_INLINE const int* hkVdbDisplayHandler::UpdateGeometryCmd::getParticleUpdateId() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440887, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == UPDATE_PARTICLE_TRANSFORMS )
    {
        return &m_particleUpdateId;
    }

    return HK_NULL;
}

HK_INLINE hkVdbDisplayHandler::AnyGeometryCmd::~AnyGeometryCmd()
{
    if ( const hkVdbDisplayHandler::AddGeometryCmd* addCmd = asAddCmd() )
    {
        hkReferencedObject::removeReferences( addCmd->m_geometry.begin(), addCmd->m_geometry.getSize() );
        addCmd->~AddGeometryCmd();
    }
    else if ( const hkVdbDisplayHandler::InstanceGeometryCmd* instanceCmd = asInstanceCmd() )
    {
        instanceCmd->~InstanceGeometryCmd();
    }
    else if ( const hkVdbDisplayHandler::UpdateGeometryCmd* updateCmd = asUpdateCmd() )
    {
        updateCmd->~UpdateGeometryCmd();
    }
    else if ( const hkVdbDisplayHandler::RemoveGeometryCmd* removeCmd = asRemoveCmd() )
    {
        removeCmd->~RemoveGeometryCmd();
    }
    else if ( const hkVdbDisplayHandler::DisposeGeometryCmd* disposeCmd = asDisposeCmd() )
    {
        disposeCmd->~DisposeGeometryCmd();
    }
    else
    {
        HK_ASSERT( 0x22441125, m_cmdType == hkVdbCmdType::INVALID, "Unknown geometry cmd" );
    }
}

HK_INLINE hkVdbDisplayHandler::AnyGeometryCmd& hkVdbDisplayHandler::AnyGeometryCmd::operator=( const hkVdbDisplayHandler::GeometryCmd& cmd )
{
    if ( m_cmdType != hkVdbCmdType::INVALID )
    {
        this->~AnyGeometryCmd();
    }

    if ( const hkVdbDisplayHandler::AddGeometryCmd* addCmd = cmd.asAddCmd() )
    {
        hkVdbDisplayHandler::AddGeometryCmd* selfAsAddCmd = reinterpret_cast<hkVdbDisplayHandler::AddGeometryCmd*>(this);
        new (selfAsAddCmd) hkVdbDisplayHandler::AddGeometryCmd();
        *selfAsAddCmd = *addCmd;
        hkReferencedObject::addReferences( addCmd->m_geometry.begin(), addCmd->m_geometry.getSize() );
    }
    else if ( const hkVdbDisplayHandler::InstanceGeometryCmd* instanceCmd = cmd.asInstanceCmd() )
    {
        hkVdbDisplayHandler::InstanceGeometryCmd* selfAsInstanceCmd = reinterpret_cast<hkVdbDisplayHandler::InstanceGeometryCmd*>(this);
        new (selfAsInstanceCmd) hkVdbDisplayHandler::InstanceGeometryCmd();
        *selfAsInstanceCmd = *instanceCmd;
    }
    else if ( const hkVdbDisplayHandler::UpdateGeometryCmd* updateCmd = cmd.asUpdateCmd() )
    {
        // Update below code if this assert fires
        HK_COMPILE_TIME_ASSERT( hkVdbDisplayHandler::UpdateGeometryCmd::SENTINEL == 128 );
        hkVdbDisplayHandler::UpdateGeometryCmd* selfAsUpdateCmd = reinterpret_cast<hkVdbDisplayHandler::UpdateGeometryCmd*>(this);
        // Initialize
        new (selfAsUpdateCmd) hkVdbDisplayHandler::UpdateGeometryCmd();
        // Copy base class members
        *static_cast<hkVdbDisplayHandler::GeometryCmd*>(selfAsUpdateCmd) = *static_cast<const hkVdbDisplayHandler::GeometryCmd*>(updateCmd);
        // Update bits
        selfAsUpdateCmd->m_updateBits = updateCmd->m_updateBits;
        // Grab dependent properties
        if ( const hkMatrix4* transform = updateCmd->getTransform() )
        {
            selfAsUpdateCmd->m_transform = *transform;
        }
        if ( const hkColor::Argb* color = updateCmd->getColor() )
        {
            selfAsUpdateCmd->m_color = *color;
        }
        if ( const hkReal* alpha = updateCmd->getAlpha() )
        {
            selfAsUpdateCmd->m_alpha = *alpha;
        }
        if ( const hkArray<hkVector4>* verts = updateCmd->getVerts() )
        {
            selfAsUpdateCmd->m_newVertices = *verts;
        }
        if ( const hkArray<hkTransform>* particleTransforms = updateCmd->getParticleTransforms() )
        {
            selfAsUpdateCmd->m_newParticleTransforms = *particleTransforms;
        }
        if ( const int* updateId = updateCmd->getParticleUpdateId() )
        {
            selfAsUpdateCmd->m_particleUpdateId = *updateId;
        }
        if ( const hkDisplayGeometryFlags* setFlagBits = updateCmd->getSetFlagBits() )
        {
            selfAsUpdateCmd->m_setFlagBits = *setFlagBits;
        }
        if ( const hkDisplayGeometryFlags* clearFlagBits = updateCmd->getClearFlagBits() )
        {
            selfAsUpdateCmd->m_clearFlagBits = *clearFlagBits;
        }
    }
    else if ( const hkVdbDisplayHandler::RemoveGeometryCmd* removeCmd = cmd.asRemoveCmd() )
    {
        hkVdbDisplayHandler::RemoveGeometryCmd* selfAsRemoveCmd = reinterpret_cast< hkVdbDisplayHandler::RemoveGeometryCmd* >( this );
        new ( selfAsRemoveCmd ) hkVdbDisplayHandler::RemoveGeometryCmd();
        *selfAsRemoveCmd = *removeCmd;
    }
    else if ( const hkVdbDisplayHandler::DisposeGeometryCmd* disposeCmd = cmd.asDisposeCmd() )
    {
        hkVdbDisplayHandler::DisposeGeometryCmd* selfAsDisposeCmd = reinterpret_cast< hkVdbDisplayHandler::DisposeGeometryCmd* >( this );
        new ( selfAsDisposeCmd ) hkVdbDisplayHandler::DisposeGeometryCmd();
        *selfAsDisposeCmd = *disposeCmd;
    }
    else
    {
        HK_ASSERT( 0x22441125, false, "Unknown geometry cmd" );
    }

    return *this;
}

HK_INLINE const hkVdbDisplayHandler::DisplayGeometryCmd* hkVdbDisplayHandler::DisplayCmd::asGeometryCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440888, m_cmdType != INVALID, "Cmd type was not set" );

    if (( m_cmdType == DISPLAY_GEOMETRY ) ||
        ( m_cmdType == DEPRECATED_DISPLAY_GEOMETRY ) )
    {
        return reinterpret_cast< const DisplayGeometryCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::Display1PtCmd* hkVdbDisplayHandler::DisplayCmd::as1PtCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440889, m_cmdType != INVALID, "Cmd type was not set" );

    if (( m_cmdType == DISPLAY_POINT ) ||
        ( m_cmdType == DISPLAY_POINT_EX ) )
    {
        return reinterpret_cast< const Display1PtCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::Display2PtCmd* hkVdbDisplayHandler::DisplayCmd::as2PtCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440890, m_cmdType != INVALID, "Cmd type was not set" );

    if (( m_cmdType == DISPLAY_2_POINTS ) ||
        ( m_cmdType == DISPLAY_2_POINTS_EX ) )
    {
        return reinterpret_cast< const Display2PtCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::Display3PtCmd* hkVdbDisplayHandler::DisplayCmd::as3PtCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440891, m_cmdType != INVALID, "Cmd type was not set" );

    if (( m_cmdType == DISPLAY_3_POINTS ) ||
        ( m_cmdType == DISPLAY_3_POINTS_EX ) )
    {
        return reinterpret_cast< const Display3PtCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::DisplayTextCmd* hkVdbDisplayHandler::DisplayCmd::asTextCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440892, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == DISPLAY_TEXT )
    {
        return reinterpret_cast< const DisplayTextCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::Display3dTextCmd* hkVdbDisplayHandler::DisplayCmd::as3dTextCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440893, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == DISPLAY_3D_TEXT )
    {
        return reinterpret_cast< const Display3dTextCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::Display1PtCmd::Ex* hkVdbDisplayHandler::Display1PtCmd::getExtended() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440894, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == DISPLAY_POINT_EX )
    {
        return &m_extended;
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::Display2PtCmd::Ex* hkVdbDisplayHandler::Display2PtCmd::getExtended() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22441219, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == DISPLAY_2_POINTS_EX )
    {
        return &m_extended;
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::UpdateCameraCmd* hkVdbDisplayHandler::CameraCmd::asUpdateCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440895, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == UPDATE_CAMERA )
    {
        return reinterpret_cast< const UpdateCameraCmd* >( this );
    }

    return HK_NULL;
}

HK_INLINE const hkVdbDisplayHandler::RemoveCameraCmd* hkVdbDisplayHandler::CameraCmd::asRemoveCmd() const
{
    using namespace hkVdbCmdType;

    HK_ASSERT( 0x22440896, m_cmdType != INVALID, "Cmd type was not set" );

    if ( m_cmdType == REMOVE_CAMERA )
    {
        return reinterpret_cast< const RemoveCameraCmd* >( this );
    }

    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
