// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkVisualDebuggerCmdType.h>

#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCmdHandler.h>

struct hkVdbCmd;

//////////////////////////////////////////////////////////////////////////
/// A handler for custom cmds.
/// Custom cmds are the easiest way to add cmds for the server to send to
/// the client.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbCustomHandler : public hkVdbCmdHandler<hkVdbCmdHandlerType::CUSTOM>
{
public:
    HK_DECLARE_CLASS( hkVdbCustomHandler, New );
    hkVdbCustomHandler();

    //
    // hkVdbCmdHandler interface.
    //

    virtual hkResult registerSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult unregisterSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) HK_OVERRIDE;

    //
    // Signals
    //

    
    /// Info about the custom cmd.
    struct CmdInfo
    {
        HK_DECLARE_CLASS( CmdInfo, New );

        /// The protocol of the server sending this cmd.
        int m_protocol;

        /// The type of cmd.
        hkVdbCmdType::Enum m_type;

        /// The custom type of the cmd.
        hkVdbCustomCmdType::Enum m_customType;

        /// The custom cmd data.
        hkArray<hkInt8> m_data;
    };

    HK_DECLARE_SIGNAL( CustomCmdReceivedSignal, hkSignal2< const CmdInfo&, hkVdbSignalResult& > );
    /// Fired when the server sends a custom cmd.
    CustomCmdReceivedSignal m_customCmdReceived;
    

    //
    // Internal use
    //

    hkResult processCustomCmd( const hkVdbCmd& cmd, int protocol, hkVdbLocalIStream& dataReader );

protected:

    // Avoid allocations during dispatch by having these declared and just reusing them
    CmdInfo m_cmdInfo;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
