// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCustomHandler.h>

#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/Command/hkVdbCmdDispatcher.h>

#define DEBUG_LOG_IDENTIFIER "vdb.Cmd.Handler.Custom"
#include <Common/Base/System/Log/hkLog.hxx>

namespace
{
    hkResult handleProcessCustomCmdFunc( const hkVdbFrame& frame, const hkVdbCmd& cmd, int protocol, hkVdbLocalIStream& dataReader, hkVdbProcessInfo* processInfo, void* userHandle )
    {
        hkVdbCustomHandler* handler = reinterpret_cast< hkVdbCustomHandler* >( userHandle );
        return handler->processCustomCmd( cmd, protocol, dataReader );
    }
};

hkVdbCustomHandler::hkVdbCustomHandler() :
    hkVdbCmdHandler<hkVdbCmdHandlerType::CUSTOM>( &s_debugLog )
{}

hkResult hkVdbCustomHandler::registerSelf( hkVdbClient& client )
{
    using namespace hkVdbCmdType;

    bool succeeded = true;
    hkVdbCmdDispatcher& dispatcher = client.getCmdDispatcher();

    succeeded &= ( dispatcher.registerHandler( CUSTOM, handleProcessCustomCmdFunc, this, this ).isSuccess() );
    succeeded &= ( dispatcher.registerHandler( CUSTOM_PERSIST, handleProcessCustomCmdFunc, this, this ).isSuccess() );
    succeeded &= ( dispatcher.registerHandler( CUSTOM_DEPENDENT, handleProcessCustomCmdFunc, this, this ).isSuccess() );

    HK_VDB_VERIFY_REPORTER_CONDITION( succeeded, dispatcher, hkVdbError::CMD_HANDLER_REGISTRATION_ERROR );

    return HK_SUCCESS;
}

hkResult hkVdbCustomHandler::unregisterSelf( hkVdbClient& client )
{
    using namespace hkVdbCmdType;

    bool succeeded = true;
    hkVdbCmdDispatcher& dispatcher = client.getCmdDispatcher();

    succeeded &= ( dispatcher.unregisterHandler( CUSTOM ).isSuccess() );
    succeeded &= ( dispatcher.unregisterHandler( CUSTOM_PERSIST ).isSuccess() );
    succeeded &= ( dispatcher.unregisterHandler( CUSTOM_DEPENDENT ).isSuccess() );

    HK_VDB_VERIFY_REPORTER_CONDITION( succeeded, dispatcher, hkVdbError::CMD_HANDLER_REGISTRATION_ERROR );

    return HK_SUCCESS;
}

void hkVdbCustomHandler::onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection ) {}

hkResult hkVdbCustomHandler::processCustomCmd( const hkVdbCmd& cmd, int protocol, hkVdbLocalIStream& dataReader )
{
    using namespace hkVdbCmdType;
    using namespace hkVdbCmdUtils;

    m_cmdInfo.m_protocol = protocol;
    m_cmdInfo.m_type = cmd.getType();
    m_cmdInfo.m_customType = hkVdbCustomCmdType::Enum( dataReader.read16u() );
    m_cmdInfo.m_data.setDataUserFree(
        reinterpret_cast< hkInt8* >( const_cast< void* >( cmd.getData( s16 ) ) ),
        cmd.getDataSize() - s16,
        cmd.getDataSize() - s16 );

    HK_VDB_VERIFY_CONDITION_MSG( dataReader.isOk(), 0xedb00056, hkVdbError::CMD_HANDLER_READ_ERROR, "Corruption after custom cmd read" );

    // Signal
    hkVdbSignalResult result;
    m_customCmdReceived.fire( m_cmdInfo, result );
    HK_VDB_VERIFY_SIGNAL_RESULT( result );

    return HK_SUCCESS;
}

#if 0

void MyCustomCmdListener::onCustomCmdReceivedSignal( const hkVdbCustomHandler::CmdInfo& info, hkVdbSignalResult& result )
{
    if ( info.m_customType == hkVdbCustomCmdType::USER_CMD0 )
    {
        hkVdbLocalIStream dataReader( info.m_data );

        // Custom action
        // dataReader.readX()...
}
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
