// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCmdHandler.h>

#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbSetupHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbProcessHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbPlaybackHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbDisplayHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbObjectHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbStatsHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbTextHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbFileHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCustomHandler.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbInternalHandler.h>

// Need to update switch-tables and default handlers below









HK_COMPILE_TIME_ASSERT( hkVdbCmdHandlerType::NUM_TYPES == 9 );

#define CALL_ANY_CMD_HANDLER_FUNC( HANDLER, FUNC, ... ) \
    switch ( HANDLER->getType() ) \
    { \
        case hkVdbCmdHandlerType::DISPLAY: reinterpret_cast< hkVdbDisplayHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::OBJECT: reinterpret_cast< hkVdbObjectHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::PLAYBACK: reinterpret_cast< hkVdbPlaybackHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::PROCESS: reinterpret_cast< hkVdbProcessHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::SETUP: reinterpret_cast< hkVdbSetupHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::STATS: reinterpret_cast< hkVdbStatsHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::TEXT: reinterpret_cast< hkVdbTextHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::FILE: reinterpret_cast< hkVdbFileHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::CUSTOM: reinterpret_cast< hkVdbCustomHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        case hkVdbCmdHandlerType::INVALID: reinterpret_cast< hkVdbInternalHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); break; \
        default: HK_ASSERT( 0x22440863, false, "Unknown handler type" ); break; \
    } HK_MUST_END_WITH_SEMICOLON

#define CALL_ANY_CMD_HANDLER_FUNC_RETURN( HANDLER, FUNC, ... ) \
    switch ( HANDLER->getType() ) \
    { \
        case hkVdbCmdHandlerType::DISPLAY: return reinterpret_cast< hkVdbDisplayHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::OBJECT: return reinterpret_cast< hkVdbObjectHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::PLAYBACK: return reinterpret_cast< hkVdbPlaybackHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::PROCESS: return reinterpret_cast< hkVdbProcessHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::SETUP: return reinterpret_cast< hkVdbSetupHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::STATS: return reinterpret_cast< hkVdbStatsHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::TEXT: return reinterpret_cast< hkVdbTextHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::FILE: return reinterpret_cast< hkVdbFileHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::CUSTOM: return reinterpret_cast< hkVdbCustomHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        case hkVdbCmdHandlerType::INVALID: return reinterpret_cast< hkVdbInternalHandler* >( const_cast< hkVdbAnyCmdHandler* >( HANDLER ) )->FUNC( __VA_ARGS__ ); \
        default: HK_ASSERT( 0x22440863, false, "Unknown handler type" ); break; \
    } HK_MUST_END_WITH_SEMICOLON

#define GET_ANY_CMD_HANDLER_CLASS_NAME( HANDLER ) \
    switch ( HANDLER->getType() ) \
    { \
        case hkVdbCmdHandlerType::DISPLAY: return HK_PP_STRINGIFY_NAME( hkVdbDisplayHandler ); \
        case hkVdbCmdHandlerType::OBJECT: return HK_PP_STRINGIFY_NAME( hkVdbObjectHandler ); \
        case hkVdbCmdHandlerType::PLAYBACK: return HK_PP_STRINGIFY_NAME( hkVdbPlaybackHandler ); \
        case hkVdbCmdHandlerType::PROCESS: return HK_PP_STRINGIFY_NAME( hkVdbProcessHandler ); \
        case hkVdbCmdHandlerType::SETUP: return HK_PP_STRINGIFY_NAME( hkVdbSetupHandler ); \
        case hkVdbCmdHandlerType::STATS: return HK_PP_STRINGIFY_NAME( hkVdbStatsHandler ); \
        case hkVdbCmdHandlerType::TEXT: return HK_PP_STRINGIFY_NAME( hkVdbTextHandler ); \
        case hkVdbCmdHandlerType::FILE: return HK_PP_STRINGIFY_NAME( hkVdbFileHandler ); \
        case hkVdbCmdHandlerType::CUSTOM: return HK_PP_STRINGIFY_NAME( hkVdbCustomHandler ); \
        case hkVdbCmdHandlerType::INVALID: return HK_PP_STRINGIFY_NAME( hkVdbInternalHandler ); \
        default: HK_ASSERT( 0x22441372, false, "Unknown handler type" ); return HK_PP_STRINGIFY_NAME( hkVdbAnyCmdHandler ); \
    } HK_MUST_END_WITH_SEMICOLON

#define DEFINE_DYN_CAST( HANDLER_TYPE ) \
    template<> \
    HANDLER_TYPE* hkVdbAnyCmdHandler::dynCast<HANDLER_TYPE>() \
    { \
        return ( getType() == HANDLER_TYPE::getStaticType() ) ? reinterpret_cast< HANDLER_TYPE* >( this ) : HK_NULL; \
    }

DEFINE_DYN_CAST( hkVdbDisplayHandler )
DEFINE_DYN_CAST( hkVdbObjectHandler )
DEFINE_DYN_CAST( hkVdbPlaybackHandler )
DEFINE_DYN_CAST( hkVdbProcessHandler )
DEFINE_DYN_CAST( hkVdbSetupHandler )
DEFINE_DYN_CAST( hkVdbStatsHandler )
DEFINE_DYN_CAST( hkVdbTextHandler )
DEFINE_DYN_CAST( hkVdbFileHandler )
DEFINE_DYN_CAST( hkVdbCustomHandler )
DEFINE_DYN_CAST( hkVdbInternalHandler )

hkVdbAnyCmdHandler::~hkVdbAnyCmdHandler()
{
    CALL_ANY_CMD_HANDLER_FUNC( this, dtorFwd );
}

hkResult hkVdbAnyCmdHandler::waitForCompletion()
{
    CALL_ANY_CMD_HANDLER_FUNC_RETURN( this, waitForCompletion );
    return HK_FAILURE;
}

hkResult hkVdbAnyCmdHandler::registerSelf( hkVdbClient& client )
{
    CALL_ANY_CMD_HANDLER_FUNC_RETURN( this, registerSelf, client );
    return HK_FAILURE;
}

hkResult hkVdbAnyCmdHandler::unregisterSelf( hkVdbClient& client )
{
    CALL_ANY_CMD_HANDLER_FUNC_RETURN( this, unregisterSelf, client );
    return HK_FAILURE;
}

void hkVdbAnyCmdHandler::onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection )
{
    CALL_ANY_CMD_HANDLER_FUNC( this, onConnectedSignal, use, connection );
}

const char* hkVdbAnyCmdHandler::getClassName() const
{
    GET_ANY_CMD_HANDLER_CLASS_NAME( this );
}

void hkVdbAnyCmdHandler::reportErrorCustom( hkUint32 id, hkVdbError::Enum error, const char* msg ) const
{
    CALL_ANY_CMD_HANDLER_FUNC( this, reportErrorCustomFwd, id, error, msg );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
