// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/Hash/hkHashMap.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>

class hkDynamicLibrary;
class hkVdbPlugin;

//////////////////////////////////////////////////////////////////////////
/// Warning: This class has not been thoroughly tested and is not currently
/// being used by Havok's Visual Debugger frontend implementation.
/// The hkVdbPluginManager can be used to load hkVdbPlugins.
/// This class, in combination with hkVdbPlugins, is simply one way
/// to manage registering pieces of code with hkVdbClients even across
/// a Dll boundary.
//////////////////////////////////////////////////////////////////////////



class HK_EXPORT_VDB hkVdbPluginManager : public hkVdbDefaultErrorReporter
{

public:

    HK_DECLARE_CLASS( hkVdbPluginManager, New );
    hkVdbPluginManager();
    ~hkVdbPluginManager();

    //
    // Loading
    //

    /// Looks for a "createVdbPlugin" function in a Dll specified at fullPath.
    /// Calls that function to create an instance of the plugin for later
    /// registration with hkVdbClients.
    hkResult load( const char* fullPath );

    /// Call load(...) for each file in dirPath (optionally recurse).
    hkResult loadAll( const char* dirPath, bool recurse = true );

    /// Unload all loaded plugins.
    hkResult unloadAll();

    //
    // Plugin access
    //
    
    /// Get loaded plugin by name.
    hkVdbPlugin* getLoadedPlugin( const char* pluginName ) const;

    /// Get loaded plugin by name and return as a specific type.
    template <typename T> T* getLoadedPlugin( const char* pluginName ) { return static_cast< T* >( getLoadedPlugin( pluginName ) ); }

    /// Get all loaded plugins and return number of loaded plugins (Note: pluginsOut is not cleared).
    int getLoadedPlugins( hkArray<hkVdbPlugin*>& pluginsOut ) const;

    //
    // Registration
    //

    /// Register loaded plugins with a vdb client.
    /// Note: some plugins might require some setup before they are ready to be registered, see getLoadedPlugin()
    hkResult registerPlugins( hkVdbClient& client );

    /// Unregister loaded plugins with a vdb client.
    hkResult unregisterPlugins( hkVdbClient& client );

protected:

    struct PluginInfo
    {
        HK_DECLARE_CLASS( PluginInfo, New );
        PluginInfo();
        ~PluginInfo();
        hkRefPtr<hkDynamicLibrary> m_dll;
        hkRefPtr<hkVdbPlugin> m_plugin;
        bool m_registered;
    };

    hkResult unloadInternal( PluginInfo* pluginInfo );

    hkHashMap<const char*, PluginInfo*> m_pluginInfos;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
