// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>

class hkVdbClient;
struct hkVdbSignalResult;

namespace hkMemoryInitUtil { struct SyncInfo; }

//////////////////////////////////////////////////////////////////////////
/// An hkVdbPlugin is a class which is called upon to initialize
/// itself and register with created hkVdbClients.
/// This class, in combination with the hkVdbPluginManager, is simply one way
/// to manage registering pieces of code with hkVdbClients even across
/// a Dll boundary (although dlls are not currently being used by Havok's
/// Visual Debugger frontend implementation).
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbPlugin : public hkVdbDefaultErrorReporter
{
public:

    HK_DECLARE_CLASS( hkVdbPlugin, New );

    /// Create a plugin which reports errors via the given log origin.
    hkVdbPlugin( hkLog::Origin* log ) : hkVdbDefaultErrorReporter( log ) {}

    //
    // Init/Quit
    //

    /// Synchronize the plugin's hkBaseSystem with main exe and initialize any other hkBase-reliant properties.
    virtual hkResult init( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* dllErrorStream = HK_NULL ) = 0;

    /// Detach from the main exe and cease using any hkBase-reliant resources.
    virtual hkResult quit() = 0;

    //
    // Registration
    //

    /// Register with the vdb client. The plugin should attach to any signalling/callbacks it requires
    /// to achieve its purposes in this function.
    virtual hkResult registerSelf( hkVdbClient& client ) = 0;

    /// Unregister from the vdb client.  The plugin should detach itself from any signalling/callbacks
    /// it attached to in registerSelf.
    virtual hkResult unregisterSelf( hkVdbClient& client ) = 0;

    //
    // Identification
    //

    /// Get a unique name for the plugin.
    virtual const char* getName() const = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
