// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Script.Serialization;
using System.Windows;
using System.Windows.Resources;

namespace HavokVisualDebugger
{
    class hkResourceUtils
    {
        /// <summary>
        /// Reads a resource of the form "pack://application:,,,/Assembly;component/path" and returns its contents as a string
        /// </summary>
        /// <param name="resourcePath"></param>
        /// <returns>File contents or null if failure occurred</returns>
        public static string ReadPackResource(string resourcePath)
        {
            try
            {
                StreamResourceInfo streamInfo = System.Windows.Application.GetResourceStream(new Uri(resourcePath));
                using (StreamReader reader = new StreamReader(streamInfo.Stream))
                {
                    return reader.ReadToEnd();
                }
            }
            catch
            {
                return null;
            }
        }

        public static ResourceDictionary FindResourceDictionary(string uniqueKey, out object keyValue)
        {
            keyValue = null;
            foreach (ResourceDictionary dictionary in Application.Current.Resources.MergedDictionaries)
            {
                keyValue = dictionary[uniqueKey];
                if (keyValue != null)
                {
                    return dictionary;
                }
            }
            return null;
        }

        public static T ParseJsonString<T>(String json)
        {
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            T obj = serializer.Deserialize<T>(json);
            return obj;
        }

        public static string GetPackedResourcePath()
        {
            return "pack://application:,,,/HavokVisualDebugger;component/";
        }

        public static string GetResourcePath(string path)
        {
            // Try given path
            if (!string.IsNullOrEmpty(path) && !System.IO.File.Exists(path))
            {
                // Try resource path
                return hkResourceUtils.GetPackedResourcePath() + path;
            }
            else
            {
                return null;
            }
        }

        public static void EmbeddedResourceToFile(string resourceSubfolder, string relativeFilename)
        {
            try
            {
                // Get the executable path, otherwise we're working based off the working directory, which
                // can be different from where the executable is actually located.
                string codeBase = System.Reflection.Assembly.GetEntryAssembly().CodeBase;

                // Strip "file:///" prefix
                codeBase = codeBase.Replace("file:///", "");

                string executablePath = Path.GetDirectoryName(codeBase);
                string absoluteFilename = Path.Combine(executablePath, relativeFilename);

                // Qualify the embedded resource.  Assuming these live in the "Resources" directory
                string subfolder = String.IsNullOrEmpty(resourceSubfolder) ? "" : "." + resourceSubfolder;
                string resourceName = "HavokVisualDebugger.Resources" + subfolder + "." + relativeFilename;

                // Access the embedded resource stream from the assembly manifest
                using (System.IO.Stream embeddedResourceStream = System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
                {
                    if (embeddedResourceStream == null)
                    {
                        return;
                    }

                    // If the file exists, make sure it's the same length
                    if (System.IO.File.Exists(absoluteFilename))
                    {
                        System.IO.FileInfo fileInfo = new System.IO.FileInfo(absoluteFilename);

                        // File is expected length, early out
                        if (fileInfo.Length == embeddedResourceStream.Length)
                        {
                            return;
                        }

                        // File is different length, delete and re-create
                        System.IO.File.Delete(absoluteFilename);
                    }

                    // Create a file on the hard drive from the embedded resource
                    using (System.IO.FileStream fileWriteStream = new System.IO.FileStream(absoluteFilename, System.IO.FileMode.Create))
                    {
                        byte[] resourceBytes = new byte[embeddedResourceStream.Length];
                        embeddedResourceStream.Read(resourceBytes, 0, resourceBytes.Length);
                        fileWriteStream.Write(resourceBytes, 0, resourceBytes.Length);
                    }
                }
            }
            catch
            {
            }
        }
        
        public static Uri GetThemeUri(string themeName)
        {
            return new Uri(@"/ResourceDictionaries/Themes/" + themeName + ".xaml", UriKind.Relative);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
