// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Globalization;

namespace HavokVisualDebugger
{
    public static class hkMath
    {
        public static T Clamp<T>(T val, T min, T max) where T : IComparable<T>
        {
            if (val.CompareTo(min) < 0) return min;
            else if (val.CompareTo(max) > 0) return max;
            else return val;
        }
        public static IComparable Clamp(IComparable val, IComparable min, IComparable max)
        {
            if (val.CompareTo(min) < 0) return min;
            else if (val.CompareTo(max) > 0) return max;
            else return val;
        }
        public static int CompareFloats(object float1, object float2)
        {
            Double? d1 = GetFloat(float1);
            Double? d2 = GetFloat(float2);
            if (d1.HasValue && d2.HasValue) return d1.Value.CompareTo(d2.Value);
            else if (d1.HasValue) return -1;
            else if (d2.HasValue) return +1;
            else return 0;
        }
        public static int CompareSignedIntegers(object int1, object int2)
        {
            Int64? i1 = GetSignedInteger(int1);
            Int64? i2 = GetSignedInteger(int2);
            if (i1.HasValue && i2.HasValue) return i1.Value.CompareTo(i2.Value);
            else if (i1.HasValue) return -1;
            else if (i2.HasValue) return +1;
            else return 0;
        }
        public static int CompareUnsignedIntegers(object uint1, object uint2)
        {
            UInt64? ui1 = GetUnsignedInteger(uint1);
            UInt64? ui2 = GetUnsignedInteger(uint2);
            if (ui1.HasValue && ui2.HasValue) return ui1.Value.CompareTo(ui2.Value);
            else if (ui1.HasValue) return -1;
            else if (ui2.HasValue) return +1;
            else return 0;
        }
        public static bool TryHexParse(string s, out Single result)
        {
            Double d;
            if (TryHexParse(s, out d))
            {
                try
                {
                    result = Convert.ToSingle(d);
                    return true;
                }
                catch { }
            }
            result = 0;
            return false;
        }
        public static bool TryHexParse(string s, out Double result)
        {
            Int64 i;
            if (TryHexParse(s, out i))
            {
                try
                {
                    result = BitConverter.Int64BitsToDouble(i);
                    return true;
                }
                catch { }
            }
            result = 0;
            return false;
        }
        public static bool TryHexParse(string s, out Decimal result)
        {
            Double d;
            if (TryHexParse(s, out d))
            {
                try
                {
                    result = Convert.ToDecimal(d);
                    return true;
                }
                catch { }
            }
            result = 0;
            return false;
        }
        public static bool TryHexParse(string s, out SByte result)
        {
            return
                SByte.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out Int16 result)
        {
            return
                Int16.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out Int32 result)
        {
            return
                Int32.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out Int64 result)
        {
            return
                Int64.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out Byte result)
        {
            return
                Byte.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out UInt16 result)
        {
            return
                UInt16.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out UInt32 result)
        {
            return
                UInt32.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static bool TryHexParse(string s, out UInt64 result)
        {
            return
                UInt64.TryParse(
                    s.TrimHexStart(),
                    NumberStyles.HexNumber,
                    GetDefaultIFormatProvider(NumberStyles.HexNumber),
                    out result);
        }
        public static IFormatProvider GetDefaultIFormatProvider(NumberStyles? styles = null)
        {
            // If currency symbol is allowed, use en-US culture.
            if (styles.HasValue && (styles.Value & NumberStyles.AllowCurrencySymbol) > 0)
            {
                return new CultureInfo("en-US");
            }
            else
            {
                return CultureInfo.InvariantCulture;
            }
        }
        public static bool TryNumericCompare(object n1, object n2, out int compareOut)
        {
            if (hkReflect.IsFloatingPoint(n1) || hkReflect.IsFloatingPoint(n2))
            {
                compareOut = CompareFloats(n1, n2);
                return true;
            }

            if (hkReflect.IsSignedInteger(n1) || hkReflect.IsSignedInteger(n2))
            {
                compareOut = CompareSignedIntegers(n1, n2);
                return true;
            }

            if (hkReflect.IsUnsignedInteger(n1) || hkReflect.IsUnsignedInteger(n2))
            {
                compareOut = CompareUnsignedIntegers(n1, n2);
                return true;
            }

            compareOut = 0;
            return false;
        }
        public static Double? GetFloat(object f)
        {
            string fstr = (f as string);
            if (fstr != null)
            {
                Double d;
                if (Double.TryParse(fstr, out d) || TryHexParse(fstr, out d))
                {
                    return d;
                }
                else
                {
                    return null;
                }
            }
            else
            {
                IFormatProvider provider = GetDefaultIFormatProvider();
                Single? s = (f as Single?);
                if (s.HasValue) return (s.Value as IConvertible).ToDouble(provider);
                Double? d = (f as Double?);
                if (d.HasValue) return s.Value;
                Decimal? de = (f as Decimal?);
                if (de.HasValue) return (de.Value as IConvertible).ToDouble(provider);
            }
            return null;
        }
        public static Int64? GetSignedInteger(object i)
        {
            string istr = (i as string);
            if (istr != null)
            {
                Int64 i64;
                if (Int64.TryParse(istr, out i64) || TryHexParse(istr, out i64))
                {
                    return i64;
                }
                else
                {
                    return null;
                }
            }
            else
            {
                IFormatProvider provider = GetDefaultIFormatProvider();
                SByte? i8 = (i as SByte?);
                if (i8.HasValue) return i8.Value;
                Int16? i16 = (i as Int16?);
                if (i16.HasValue) return i16.Value;
                Int32? i32 = (i as Int32?);
                if (i32.HasValue) return i32.Value;
                Int64? i64 = (i as Int64?);
                if (i64.HasValue) return i64.Value;
            }
            return null;
        }
        public static UInt64? GetUnsignedInteger(object ui)
        {
            string uistr = (ui as string);
            if (uistr != null)
            {
                UInt64 ui64;
                if (UInt64.TryParse(uistr, out ui64) || TryHexParse(uistr, out ui64))
                {
                    return ui64;
                }
                else
                {
                    return null;
                }
            }
            else
            {
                IFormatProvider provider = GetDefaultIFormatProvider();
                Byte? ui8 = (ui as Byte?);
                if (ui8.HasValue) return ui8.Value;
                UInt16? ui16 = (ui as UInt16?);
                if (ui16.HasValue) return ui16.Value;
                UInt32? ui32 = (ui as UInt32?);
                if (ui32.HasValue) return ui32.Value;
                UInt64? ui64 = (ui as UInt64?);
                if (ui64.HasValue) return ui64.Value;
            }
            return null;
        }

        
        
#if DEBUG
#if false
        static hkMath()
        {
            {
                SByte integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0x7f", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7f);
                System.Diagnostics.Debug.Assert(TryHexParse("x7f", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7f);
                System.Diagnostics.Debug.Assert(TryHexParse("&h7f", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7f);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("0x7f", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0x7f", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0x78", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                Int16 integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0x7fff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fff);
                System.Diagnostics.Debug.Assert(TryHexParse("x7fff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fff);
                System.Diagnostics.Debug.Assert(TryHexParse("&h7fff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("x7fff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("x7fff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("x7ff8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                Int32 integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0x7fffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("x7fffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("&h7fffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fffffff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("&h7fffffff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("&h7fffffff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("&h7ffffff8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                Int64 integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0x7fffffffffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fffffffffffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("x7fffffffffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fffffffffffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("&h7fffffffffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0x7fffffffffffffff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("0x7fffffffffffffff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0x7fffffffffffffff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0x7ffffffffffffff8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                Byte integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0xff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xff);
                System.Diagnostics.Debug.Assert(TryHexParse("xff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xff);
                System.Diagnostics.Debug.Assert(TryHexParse("&hff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("0xff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0xff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0xf8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                UInt16 integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0xffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffff);
                System.Diagnostics.Debug.Assert(TryHexParse("xffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffff);
                System.Diagnostics.Debug.Assert(TryHexParse("&hffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("xffff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("xffff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("xfff8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                UInt32 integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0xffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("xffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("&hffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffffffff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("&hffffffff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("&hffffffff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("&hfffffff8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
            {
                UInt64 integer;
                System.Diagnostics.Debug.Assert(TryHexParse("0xffffffffffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffffffffffffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("xffffffffffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffffffffffffffff);
                System.Diagnostics.Debug.Assert(TryHexParse("&hffffffffffffffff", out integer));
                System.Diagnostics.Debug.Assert(integer == 0xffffffffffffffff);
                int compareOut;
                System.Diagnostics.Debug.Assert(TryNumericCompare("0xffffffffffffffff", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut == 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0xffffffffffffffff", integer - 1, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut > 0);
                System.Diagnostics.Debug.Assert(TryNumericCompare("0xfffffffffffffff8", integer, out compareOut));
                System.Diagnostics.Debug.Assert(compareOut < 0);
            }
        }
#endif
#endif
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
