// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Windows;
using System.Windows.Input;

namespace HavokVisualDebugger
{
    public class hkMouseDoubleClickDetector
    {
        public hkMouseDoubleClickDetector()
        {
            //m_control = new FwdControl();
            //m_control.Width = 100;
            //m_control.Height = 100;
            //m_control.MouseDoubleClick += OnMouseDoubleClick;
        }

        public void Hook(UIElement element, MouseButtonEventHandler handler)
        {
            UnHook();
            if (element != null)
            {
                element.MouseDown += OnMouseDown;
                element.MouseUp += OnMouseUp;
                m_handler = handler;
                m_element = element;
            }
        }

        public void UnHook()
        {
            if (m_element != null)
            {
                m_element.MouseDown += OnMouseDown;
                m_element.MouseUp += OnMouseUp;
                m_handler = null;
                m_element = null;
            }
        }

        protected void OnMouseDown(object sender, MouseButtonEventArgs e)
        {
            System.Diagnostics.Debug.Assert(sender == m_element);
            //m_control.FireMouseDown(e);
            if (e.ClickCount == 2)
            {
                OnMouseDoubleClick(sender, e);
            }
        }

        protected void OnMouseUp(object sender, MouseButtonEventArgs e)
        {
            System.Diagnostics.Debug.Assert(sender == m_element);
            //m_control.FireMouseUp(e);
        }

        protected void OnMouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            m_handler(m_element, e);
        }

        //protected class FwdControl : System.Windows.Controls.UserControl
        //{
        //    public void FireMouseDown(MouseButtonEventArgs e)
        //    {
        //        base.OnPreviewMouseDown(e);
        //    }
        //    public void FireMouseUp(MouseButtonEventArgs e)
        //    {
        //        base.OnPreviewMouseUp(e);
        //    }
        //}

        //protected FwdControl m_control;
        protected UIElement m_element;
        protected MouseButtonEventHandler m_handler;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
