// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;

namespace HavokVisualDebugger
{
    
    public class hkConstants
    {
        public static float LegalStatementVersion = 1.0f;

        /// <summary>
        /// A value of 0 means that this is an official stable release.
        /// Any other value corresponds directly to the changelist number that
        /// this was built against.  This value is hardcoded and needs to be updated by hand
        /// with the changelist the Vdb is being built against whenever a point release is
        /// being created.
        /// </summary>
        public static int PointReleaseChangeList = 0;

        /// <summary>
        /// List of camera names which may exist in movies representing the recorded camera.
        /// </summary>
        public static string[] RecordedCameraNames =
        {
            "Recorded Camera",
            "Viewport0 Recorded",
            "Viewport1 Recorded",
            "Viewport2 Recorded",
            "Viewport3 Recorded"
        };

        public static Dictionary<string, string> PrefixCategoryLookup
        {
            get
            {
                if (m_prefixCategoryLookup == null)
                    InitCategoryDictionaries();
                return m_prefixCategoryLookup;
            }
        }
        private static Dictionary<string, string> m_prefixCategoryLookup = null;

        public static Dictionary<string, string> ViewerCategoryLookup
        {
            get
            {
                if (m_viewerCategoryLookup == null)
                    InitCategoryDictionaries();
                return m_viewerCategoryLookup;
            }
        }
        private static Dictionary<string, string> m_viewerCategoryLookup = null;

        /// <summary>
        /// Hard-coded categories
        /// </summary>
        
        private static void InitCategoryDictionaries()
        {
            if (m_prefixCategoryLookup == null)
            {
                m_prefixCategoryLookup = new Dictionary<string, string>();
                m_prefixCategoryLookup["ai"] = Properties.Resources.ViewerTooltip_CategoryAi;
                m_prefixCategoryLookup["np"] = Properties.Resources.ViewerTooltip_CategoryPhysics;
                m_prefixCategoryLookup["cloth"] = Properties.Resources.ViewerTooltip_CategoryCloth;
                m_prefixCategoryLookup["behavior"] = Properties.Resources.ViewerTooltip_CategoryBehavior;
                m_prefixCategoryLookup["nd"] = Properties.Resources.ViewerTooltip_CategoryDestruction;
            }

            if(m_viewerCategoryLookup == null)
            {
                // Physics 2012 has no prefixes, need to parse viewers individually (yuck)
                m_viewerCategoryLookup = new Dictionary<string, string>();
                m_viewerCategoryLookup["broadphase"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["midphase"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["center of mass"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["physics local frames"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["constraints"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["convex radius"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["contact points (active)"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["contact points (inactive)"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["contact points (toi)"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["toi counter"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["inertia tensors"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["mouse picking"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["phantoms"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["shapes"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["trigger volumes"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["simulation islands"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["swept transforms"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["vehicles"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["welding"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["inconsistentwindingviewer"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["constraint viewer - single body"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["* grab world snapshot (xml tagfile)"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;
                m_viewerCategoryLookup["* grab world snapshot (binary tagfile)"] = Properties.Resources.ViewerTooltip_CategoryPhysics2012;

                // Physics
                m_viewerCategoryLookup["* grab np world snapshot (xml tagfile)"] = Properties.Resources.ViewerTooltip_CategoryPhysics;
                m_viewerCategoryLookup["* grab np world snapshot (binary tagfile)"] = Properties.Resources.ViewerTooltip_CategoryPhysics;

                // Ai
                m_viewerCategoryLookup["collision avoidance - characters"] = Properties.Resources.ViewerTooltip_CategoryAi;
                m_viewerCategoryLookup["collision avoidance - obstacles"] = Properties.Resources.ViewerTooltip_CategoryAi;

                // Behavior
                m_viewerCategoryLookup["behaviorserver"] = Properties.Resources.ViewerTooltip_CategoryBehavior;
                m_viewerCategoryLookup["character model vectors"] = Properties.Resources.ViewerTooltip_CategoryBehavior;
                m_viewerCategoryLookup["parametric motion generators"] = Properties.Resources.ViewerTooltip_CategoryBehavior;

                // Destruction 2012
                m_viewerCategoryLookup["breakableshape connection viewer"] = Properties.Resources.ViewerTooltip_CategoryDestruction2012;
                m_viewerCategoryLookup["wood damage viewer"] = Properties.Resources.ViewerTooltip_CategoryDestruction2012;
                m_viewerCategoryLookup["breakableshape graphics name viewer"] = Properties.Resources.ViewerTooltip_CategoryDestruction2012;
                m_viewerCategoryLookup["destruction event tracker viewer"] = Properties.Resources.ViewerTooltip_CategoryDestruction2012;

                // Common
                m_viewerCategoryLookup["remoteobject"] = Properties.Resources.ViewerTooltip_CategoryCommon;
                m_viewerCategoryLookup["debug display"] = Properties.Resources.ViewerTooltip_CategoryCommon;
                m_viewerCategoryLookup["scene data"] = Properties.Resources.ViewerTooltip_CategoryCommon;
                m_viewerCategoryLookup["statistics"] = Properties.Resources.ViewerTooltip_CategoryCommon;
            }
        }

    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
