// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;

namespace HavokVisualDebugger
{
    class hkColorUtils
    {
        public static System.Drawing.Color ColorFromHSV(double hue, double saturation, double value, int alpha = 255)
        {
            int hi = Convert.ToInt32(Math.Floor(hue / 60)) % 6;
            double f = hue / 60 - Math.Floor(hue / 60);

            value = value * 255;
            int v = Convert.ToInt32(value);
            int p = Convert.ToInt32(value * (1 - saturation));
            int q = Convert.ToInt32(value * (1 - f * saturation));
            int t = Convert.ToInt32(value * (1 - (1 - f) * saturation));

            if (hi == 0)
                return System.Drawing.Color.FromArgb(alpha, v, t, p);
            else if (hi == 1)
                return System.Drawing.Color.FromArgb(alpha, q, v, p);
            else if (hi == 2)
                return System.Drawing.Color.FromArgb(alpha, p, v, t);
            else if (hi == 3)
                return System.Drawing.Color.FromArgb(alpha, p, q, v);
            else if (hi == 4)
                return System.Drawing.Color.FromArgb(alpha, t, p, v);
            else
                return System.Drawing.Color.FromArgb(alpha, v, p, q);
        }

        public static void ColorToHSV(System.Drawing.Color color, out double hue, out double saturation, out double value)
        {
            int max = Math.Max(color.R, Math.Max(color.G, color.B));
            int min = Math.Min(color.R, Math.Min(color.G, color.B));

            // System.Drawing.Color properly computes the Hue
            hue = color.GetHue();

            // System.Drawing.Color has a GetSaturation/GetBrightness, but these values are actually in HSL space (Hue/Saturation/Lightness)
            // not HSV or HSB (Hue/Saturation/Value or Brightness, they are the same).
            // As a side note: the .Net documentation is wrong here, it states that it does HSB, but GetBrightness actually returns
            // luminance values (hence why it is actually HSL).
            saturation = (max == 0) ? 0 : 1.0 - (1.0 * min / max);
            value = max / 255.0;
        }

        public static int ColorToArgb(System.Drawing.Color inColor)
        {
            int outColor = inColor.A << 24;
            outColor |= inColor.R << 16;
            outColor |= inColor.G << 8;
            outColor |= inColor.B << 0;

            return outColor;
        }

        public static int ColorToArgb(System.Windows.Media.Color inColor)
        {
            return ColorToArgb(MediaColorToDrawingColor(inColor));
        }
        
        public static System.Windows.Media.Color ArgbToColor(int argb)
        {
            return DrawingColorToMediaColor(System.Drawing.Color.FromArgb(argb));
        }

        public static System.Windows.Media.Color DrawingColorToMediaColor(System.Drawing.Color color)
        {
            return System.Windows.Media.Color.FromArgb(color.A, color.R, color.G, color.B);
        }

        public static System.Drawing.Color MediaColorToDrawingColor(System.Windows.Media.Color color)
        {
            return System.Drawing.Color.FromArgb(color.A, color.R, color.G, color.B);
        }

        public static string ToHex(System.Drawing.Color color, bool includeAlpha)
        {
            return "#" + (includeAlpha ? color.A.ToString("X2") : "") + color.R.ToString("X2") + color.G.ToString("X2") + color.B.ToString("X2");
        }

        public static string ToHex(System.Windows.Media.Color color, bool includeAlpha)
        {
            return "#" + (includeAlpha ? color.A.ToString("X2") : "") + color.R.ToString("X2") + color.G.ToString("X2") + color.B.ToString("X2");
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
