// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using Microsoft.Diagnostics.Telemetry;
using System.Collections.Generic;
using System.Diagnostics.Tracing;

namespace HavokVisualDebugger
{
    [EventSource(Name = "Microsoft.Havok.VisualDebugger")]
    public class hkTelemetry : TelemetryEventSource
    {
        // Private ctor, force usage of Provider singleton
        private hkTelemetry() : base("Microsoft.Havok.VisualDebugger")
        {
        }

        /// <summary>
        /// Gets an EventSource singleton.
        /// </summary>
        public static hkTelemetry Provider { get { return s_provider; } }
        private static hkTelemetry s_provider = new hkTelemetry();

        public delegate void SessionEndedHandler();
        public event SessionEndedHandler SessionEnded;
        public event SessionEndedHandler SessionStarted;

        public void OnSessionStarted() { SessionStarted?.Invoke(); }
        public void OnSessionEnded() { SessionEnded?.Invoke(); }

        // The CLR generates internal event IDs for some bits of code, which will conflict with the following enum
        // and its associated event contracts below. This number may need to be raised if any additional code is
        // added to this class.
        const int NUM_EVENT_HANDLERS = 7;

        public enum TelemetryEvents
        {
            GeneralInfo = NUM_EVENT_HANDLERS,
            SizeInfo,
            PerformanceInfo,
            ConnectionInfo,
            ViewerInfo,
            CameraInfo,
            InspectorInfo,
            PlaybackInfo,
            LogViewerInfo,
            RenderInfo,
            ShortcutInfo
        }

        [Event((int)TelemetryEvents.PerformanceInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void PerformanceInfo(double avg, double max, double stdDev, double avgSecondsBetweenSpikes, double avgSpikeValues,
            double drawFrameMs, double updateFrameMs, ulong frameCount, double stepMean, double stepMax, double stepStdDev)
        {
            WriteEvent((int)TelemetryEvents.PerformanceInfo, avg, max, stdDev, avgSecondsBetweenSpikes, avgSpikeValues, drawFrameMs, updateFrameMs, frameCount, stepMean, stepMax, stepStdDev);
        }

        [Event((int)TelemetryEvents.GeneralInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void GeneralInfo(double sessionLengthInSeconds, string buildDate, int protocol, int version, string culture)
        {
            WriteEvent((int)TelemetryEvents.GeneralInfo, sessionLengthInSeconds, buildDate, protocol, version, culture);
        }

        [Event((int)TelemetryEvents.SizeInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void SizeInfo(string uiDimensions, string screenResolution, string workingArea, bool isPrimaryMonitor, int numMonitors)
        {
            WriteEvent((int)TelemetryEvents.SizeInfo, uiDimensions, screenResolution, workingArea, isPrimaryMonitor, numMonitors);
        }

        [Event((int)TelemetryEvents.ViewerInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void ViewerInfo(string enabledViewers)
        {
            WriteEvent((int)TelemetryEvents.ViewerInfo, enabledViewers );
        }

        [Event((int)TelemetryEvents.ConnectionInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void ConnectionInfo(bool isDiscoveringServers, bool autoReconnectEnabled, int numDiscoveredServers, int numServerAddressesSaved,
            int numServerPortsSaved, string connectionType, int numTimesRecorded, List<long> savedMovieSizes, List<long> savedMovieLengths)
        {
            WriteEvent((int)TelemetryEvents.ConnectionInfo, isDiscoveringServers, autoReconnectEnabled, numDiscoveredServers, numServerAddressesSaved,
                numServerPortsSaved, connectionType, numTimesRecorded, savedMovieSizes, savedMovieLengths);
        }

        [Event((int)TelemetryEvents.CameraInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void CameraInfo(int numApplicationCameras, string movementMode, string upAxis, double nearPlane,
                            double farPlane, double fieldOfView, string perspectiveMode, double lookSensitivity,
                            int fittingViewFromNegXClicks, int fittingViewFromNegYClicks, int fittingViewFromNegZClicks,
                            int fittingViewFromXClicks, int fittingViewFromYClicks, int fittingViewFromZClicks,
                            int fittingDefaultClicks, int fittingCurrentViewClicks)
        {
            WriteEvent((int)TelemetryEvents.CameraInfo, numApplicationCameras, movementMode, upAxis, nearPlane,
                            farPlane, fieldOfView, perspectiveMode, lookSensitivity,
                            fittingViewFromNegXClicks, fittingViewFromNegYClicks, fittingViewFromNegZClicks,
                            fittingViewFromXClicks, fittingViewFromYClicks, fittingViewFromZClicks,
                            fittingDefaultClicks, fittingCurrentViewClicks);
        }

        [Event((int)TelemetryEvents.PlaybackInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void PlaybackInfo(int numPlay, int numPlayForward, int numPlayBackward, int numPause, int numGoToBegin, int numGoToEnd,
            int numOneFrameForward, int numOneFrameBackward, int numSaveMovie, bool realTimePlaybackEnabled, double fpsSetting)
        {
            WriteEvent((int)TelemetryEvents.PlaybackInfo, numPlay, numPlayForward, numPlayBackward, numPause, numGoToBegin, numGoToEnd,
                numOneFrameForward, numOneFrameBackward, numSaveMovie, realTimePlaybackEnabled, fpsSetting);
        }

        [Event((int)TelemetryEvents.LogViewerInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void LogViewerInfo(int numLocalLogMessages, int numRemoteLogMessages, string maxLogLimit)
        {
            WriteEvent((int)TelemetryEvents.LogViewerInfo, numLocalLogMessages, numRemoteLogMessages, maxLogLimit);
        }

        [Event((int)TelemetryEvents.RenderInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void RenderInfo(bool orientationIsSelected, int orientationNumToggles,
            bool originIsSelected, int originNumToggles,
            bool UNUSED_IsSelected, int UNUSED_NumToggles,
            bool statsBarGraphIsSelected, int statsBarGraphNumToggles,
            bool depStatsBarGraphIsSelected, int depStatsBarGraphNumToggles,
            bool statsLineGraphIsSelected, int statsLineGraphNumToggles,
            bool statusIsSelected, int statusNumToggles,
            bool gridIsSelected, int gridNumToggles,
            bool renderWireframeIsEnabled, int renderWireframeNumToggles,
            bool renderOutlineFacesIsEnabled, int renderOutlineFacesNumToggles,
            bool randomizedColorsIsEnabled, int randomizedColorsNumToggles,
            bool lockLightToCamera, int lockLightToCameraNumToggles,
            string backfaceCullingMode, int backfaceCullingModeChanges,
            string clearColor, int clearColorChanges)
        {
            WriteEvent((int)TelemetryEvents.RenderInfo, orientationIsSelected, orientationNumToggles,
                originIsSelected, originNumToggles,
                UNUSED_IsSelected, UNUSED_NumToggles,
                statsBarGraphIsSelected, statsBarGraphNumToggles,
                depStatsBarGraphIsSelected, depStatsBarGraphNumToggles,
                statsLineGraphIsSelected, statsLineGraphNumToggles,
                statusIsSelected, statusNumToggles,
                gridIsSelected, gridNumToggles,
                renderWireframeIsEnabled, renderWireframeNumToggles,
                renderOutlineFacesIsEnabled, renderOutlineFacesNumToggles,
                randomizedColorsIsEnabled, randomizedColorsNumToggles,
                lockLightToCamera, lockLightToCameraNumToggles,
                backfaceCullingMode, backfaceCullingModeChanges,
                clearColor, clearColorChanges);
        }

        [Event((int)TelemetryEvents.ShortcutInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void ShortcutInfo(string shortcuts)
        {
            WriteEvent((int)TelemetryEvents.ShortcutInfo, shortcuts);
        }

        [Event((int)TelemetryEvents.InspectorInfo, Keywords = TelemetryEventSource.MeasuresKeyword, Level = EventLevel.LogAlways, Tags = NormalLatency)]
        public void InspectorInfo(string inspectionQueries, int filterCount, int numTreeFilterOperations, int inspectionCollapseClicks, int inspectionTreeNodeCount, int maxInspectorCount)
        {
            WriteEvent((int)TelemetryEvents.InspectorInfo, inspectionQueries, filterCount, numTreeFilterOperations, inspectionCollapseClicks, inspectionTreeNodeCount, maxInspectorCount);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
