// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Collections.Generic;
using System.Linq;

namespace HavokVisualDebugger
{
    public class VdbWidgetViewModel : ViewModelNotifyPropertyChanged
    {
        #region VdbWidgetViewModel Initialization
        public VdbWidgetViewModel(Havok.Vdb.RenderWidget widget)
        {
            m_widget = widget;
        }
        #endregion

        public void ResetToggles()
        {
            SessionNumToggles = 0;
        }

        public int SessionNumToggles { get; set; }

        public string Name { get { return m_widget.Name; } }

        public T GetOption<T>(string name)
        {
            return GetVdbPropertyValue<T>(m_widget.Options, name);
        }

        public T SetOption<T>(string name, T value)
        {
            return SetVdbPropertyValue(m_widget.Options, name, value);
        }

        public string Tooltip
        {
            get
            {
                string tooltipResource = "Settings_" + m_widget.Name + "_Tooltip";
                return Properties.Resources.ResourceManager.GetString(tooltipResource, Properties.Resources.Culture);
            }
        }

        public bool IsSelected
        {
            get { return m_widget.Enabled; }
            set
            {
                m_widget.Enabled = value;
                VdbSettings.SetCollectionItemEnabled(Properties.Settings.Default.VdbEnabledWidgets, Name, value);
                SessionNumToggles++;

                NotifyPropertyChanged();
            }
        }

        public bool IsDiagnostic
        {
            get
            {
                return (Name == "Line Graph") ||
                       (Name == "Deprecated Bar Graph") ||
                       (Name == "Bar Graph") ||
                       (Name == "Status Info") ||
                       (Name == "Stats Text");
            }
        }

        #region VdbWidgetViewModel Private Methods and Properties

        

        private T GetVdbPropertyValue<T>(IReadOnlyCollection<Havok.Vdb.Property> properties, string name)
        {
            Havok.Vdb.IProperty prop = properties.First(o => o.Name == name);
            if ((prop != null) && (prop.Value is T)) return (T) prop.Value;
            else return default(T);
        }

        private T GetVdbPropertyValue<T>(IReadOnlyCollection<Havok.Vdb.ReadOnlyProperty> properties, string name)
        {
            Havok.Vdb.IReadOnlyProperty prop = properties.First(o => o.Name == name);
            if ((prop != null) && (prop.Value is T)) return (T) prop.Value;
            else return default(T);
        }

        private T SetVdbPropertyValue<T>(IReadOnlyCollection<Havok.Vdb.Property> properties, string name, T value)
        {
            Havok.Vdb.IProperty prop = properties.First(o => o.Name == name);
            if ((prop != null) && (prop.Value is T))
            {
                object oldValue = prop.Value;
                prop.Value = value;
                return (T) oldValue;
            }
            else
            {
                return default(T);
            }
        }

        private Havok.Vdb.RenderWidget m_widget;
        #endregion
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
