// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.IO;
using System.Windows;

namespace HavokVisualDebugger
{
    public class VdbThemeViewModel : ViewModelNotifyPropertyChanged
    {
        #region VdbThemeViewModel Initialization
        public VdbThemeViewModel(ResourceDictionary resourceDictionary)
        {
            m_themeDictionary = resourceDictionary;
        }
        #endregion

        #region VdbThemeViewModel View Commands and Properties
        public string Name
        {
            get
            {
                string fullUri = m_themeDictionary.Source.OriginalString;
                string fileName = Path.GetFileNameWithoutExtension(fullUri);
                return hkStringUtils.SplitCamelCase(fileName);
            }
        }

        public ResourceDictionary Dictionary
        {
            get { return m_themeDictionary; }
        }
        #endregion

        #region VdbThemeViewModel Private Methods and Properties
        private ResourceDictionary m_themeDictionary;
        #endregion
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
