// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Net;

namespace HavokVisualDebugger
{

    public class VdbServerInfoViewModel : ViewModelNotifyPropertyChanged
    {
        #region VdbServerInfoViewModel Initialization
        public VdbServerInfoViewModel(Havok.Vdb.ServerInfo info, VdbViewModel owner)
        {
            m_serverInfo = info;
            Owner = owner;
        }
        #endregion

        public string DisplayPort
        {
            get
            {
                return m_serverInfo.Port.ToString();
            }
        }

        public string DisplayAddress
        {
            get
            {
                return m_serverInfo.IpAddress.ToString();
            }
        }

        public string DisplayName
        {
            get
            {
                return m_serverInfo.ToString();
            }
        }

        public string Name
        {
            get
            {
                return m_serverInfo.Name;
            }
        }

        public bool IsLocalHost
        {
            get
            {
                try
                {
                    IPAddress[] hostAddresses = Dns.GetHostAddresses(m_serverInfo.IpAddress.ToString());
                    IPAddress[] localAddresses = Dns.GetHostAddresses(Dns.GetHostName());

                    foreach (IPAddress hostAddress in hostAddresses)
                    {
                        if (IPAddress.IsLoopback(hostAddress))
                        {
                            return true;
                        }
                        else
                        {
                            foreach (IPAddress localAddress in localAddresses)
                            {
                                if (hostAddress.Equals(localAddress))
                                {
                                    return true;
                                }
                            }
                        }
                    }

                    return m_serverInfo.Name == "localhost" || m_serverInfo.IpAddress.Equals(0);
                }
                catch
                {
                    return false;
                }
            }
        }

        public bool IsConnected
        {
            get
            {
                try
                {

                    if (Owner == null)
                    {
                        return false;
                    }

                    if (Owner.IsConnected && Owner.ConnectedSource == Havok.Vdb.ConnectedSource.Network)
                    {
                        // Early out if ports don't match
                        if (Owner.MachinePort != m_serverInfo.Port.ToString())
                        {
                            return false;
                        }

                        if (Owner.MachineAddress == "localhost")
                        {
                            return IsLocalHost;
                        }
                        else
                        {
                            IPAddress[] serverInfoAddresses = Dns.GetHostAddresses(m_serverInfo.IpAddress.ToString());
                            IPAddress[] connectedAddresses = Dns.GetHostAddresses(Owner.MachineAddress);
                            foreach (IPAddress serverInfoAddress in serverInfoAddresses)
                            {
                                foreach (IPAddress connectedAddress in connectedAddresses)
                                {
                                    if (connectedAddress.Equals(serverInfoAddress))
                                    {
                                        return true;
                                    }
                                }
                            }
                        }
                    }

                    return false;
                }
                catch
                {
                    return false;
                }
            }
        }

        public void Update()
        {
            NotifyPropertyChanged(nameof(IsConnected));
        }

        public Havok.Vdb.ServerInfo ServerInfo { get { return m_serverInfo; } }
        private Havok.Vdb.ServerInfo m_serverInfo;

        public VdbViewModel Owner { get; set; }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
