// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Windows;

namespace HavokVisualDebugger
{
    public class VdbNewContentViewModel : ViewModelNotifyPropertyChanged
    {
        public VdbNewContentViewModel(string title)
        {
            Title = title;
            ContentParagraphs = new ObservableCollection<VdbParagraph>();
        }

        public class VdbParagraph : ViewModelNotifyPropertyChanged
        {
            public VdbParagraph(string content, string imagePath, HorizontalAlignment contentAlignment, bool contentIsHeader)
            {
                ParagraphContent = content;
                ParagraphContentAlignment = contentAlignment;
                ParagraphImagePath = imagePath;
                ContentIsHeader = contentIsHeader;
            }

            public string ParagraphContent
            {
                get { return _ParagraphContent; }
                set
                {
                    if (_ParagraphContent != value)
                    {
                        _ParagraphContent = value;
                        NotifyPropertyChanged();
                    }
                }
            }
            private string _ParagraphContent;

            public string ParagraphImagePath
            {
                get { return _ParagraphImagePath; }
                set
                {
                    if (_ParagraphImagePath != value)
                    {
                        _ParagraphImagePath = value;
                        NotifyPropertyChanged();
                        NotifyPropertyChanged(nameof(IsImageValid));
                    }
                }
            }
            private string _ParagraphImagePath;

            public HorizontalAlignment ParagraphContentAlignment
            {
                get { return _ParagraphContentAlignment; }
                set
                {
                    if (_ParagraphContentAlignment != value)
                    {
                        _ParagraphContentAlignment = value;
                        NotifyPropertyChanged();
                        NotifyPropertyChanged(nameof(ParagraphImageAlignment));
                        NotifyPropertyChanged(nameof(ImageDockPosition));
                        NotifyPropertyChanged(nameof(ContentDockPosition));
                    }
                }
            }
            private HorizontalAlignment _ParagraphContentAlignment;

            public HorizontalAlignment ParagraphImageAlignment
            {
                get
                {
                    return (ParagraphContentAlignment == HorizontalAlignment.Left) ?
                        HorizontalAlignment.Right : HorizontalAlignment.Left;
                }
            }

            public bool IsImageValid
            {
                get
                {
                    
                    return !string.IsNullOrEmpty(ParagraphImagePath);
                }
            }

            public System.Windows.Controls.Dock ImageDockPosition
            {
                get
                {
                    return (ParagraphContentAlignment == HorizontalAlignment.Left) ? System.Windows.Controls.Dock.Right : System.Windows.Controls.Dock.Left;
                }
            }

            public System.Windows.Controls.Dock ContentDockPosition
            {
                get
                {
                    return (ParagraphContentAlignment == HorizontalAlignment.Left) ? System.Windows.Controls.Dock.Left : System.Windows.Controls.Dock.Right;
                }
            }

            public bool ContentIsHeader
            {
                get { return _ContentIsHeader; }
                set
                {
                    if (_ContentIsHeader != value)
                    {
                        _ContentIsHeader = value;
                        NotifyPropertyChanged();
                    }
                }
            }
            private bool _ContentIsHeader;
        }

        public void AddContentParagraph(string content, string imagePath, HorizontalAlignment contentAlignment, bool contentIsHeader)
        {
            ContentParagraphs.Add(new VdbParagraph(content, imagePath, contentAlignment, contentIsHeader));
        }

        public ObservableCollection<VdbParagraph> ContentParagraphs { get; private set; }

        public string Title
        {
            get { return _Title; }
            set
            {
                if (_Title != value)
                {
                    _Title = value;
                    NotifyPropertyChanged();
                }
            }
        }
        private string _Title;
    }


    public class VdbNewContentVersionedList
    {
        public VdbNewContentVersionedList(string version)
        {
            Version = version;
            Content = new ObservableCollection<VdbNewContentViewModel>();
        }

        public string Version { get; set; }
        public ObservableCollection<VdbNewContentViewModel> Content { get; set; }
    }


    public class VdbNewContentManager : ViewModelNotifyPropertyChanged
    {
        public VdbNewContentManager(VdbViewModel owner)
        {
            Content = new ObservableCollection<VdbNewContentVersionedList>();
            m_owner = owner;
            LoadContent();
        }

        public void LoadContent()
        {
            List<VdbNewContentVersionedList> newContent = new List<VdbNewContentVersionedList>();
            newContent.Add(LoadContent20171());
            newContent.Add(LoadContent20172());

            // Add new content here

            for (int i = newContent.Count - 1; i >= 0; i--)
            {
                Content.Add(newContent[i]);
            }

            // Set default content
            SelectedNewContentItem = DefaultContent;
        }

        /// <summary>
        /// Loads "What's New" content for 2017.1
        /// </summary>
        private VdbNewContentVersionedList LoadContent20171()
        {
            VdbNewContentViewModel objectInspectionContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionHeader);
            {
                string treeImagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_1_0/ObjectInspectorTree.png");
                objectInspectionContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionTreeHeader, null, HorizontalAlignment.Left, true);
                objectInspectionContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionTree, treeImagePath, HorizontalAlignment.Right, false);

                string layersImagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_1_0/ObjectInspectorLayers.png");
                objectInspectionContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionLayersHeader, null, HorizontalAlignment.Right, true);
                objectInspectionContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionLayers, layersImagePath, HorizontalAlignment.Left, false);

                string propertiesImagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_1_0/ObjectInspectorProperties.png");
                objectInspectionContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionPropertiesHeader, null, HorizontalAlignment.Left, true);
                objectInspectionContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ObjectInspectionProperties, propertiesImagePath, HorizontalAlignment.Right, false);
            }

            VdbNewContentViewModel serverDiscoveryContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_1_0_ServerDiscoveryHeader);
            {
                string serverDiscoveryImagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_1_0/ServerDiscovery.png");
                serverDiscoveryContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ServerDiscoveryHeader, null, HorizontalAlignment.Left, true);
                serverDiscoveryContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_ServerDiscovery, serverDiscoveryImagePath, HorizontalAlignment.Right, false);
            }

            VdbNewContentViewModel playbackBufferContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_1_0_PlaybackBufferHeader);
            {
                string playbackBufferImagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_1_0/PlaybackBuffer.png");
                playbackBufferContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_PlaybackBufferHeader, null, HorizontalAlignment.Right, true);
                playbackBufferContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_1_0_PlaybackBuffer, playbackBufferImagePath, HorizontalAlignment.Left, false);
            }

            VdbNewContentVersionedList contentList = new VdbNewContentVersionedList("2017.1");
            {
                contentList.Content.Add(objectInspectionContent);
                contentList.Content.Add(serverDiscoveryContent);
                contentList.Content.Add(playbackBufferContent);
            }

            DefaultContent = objectInspectionContent;
            return contentList;
        }

        /// <summary>
        /// Loads "What's New" content for 2017.2
        /// </summary>
        private VdbNewContentVersionedList LoadContent20172()
        {
            VdbNewContentViewModel statisticsPanelContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_2_0_StatisticsPanelHeader);
            {
                string imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/StatisticsPanel.png");
                statisticsPanelContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_StatisticsPanelHeader, null, HorizontalAlignment.Left, true);
                statisticsPanelContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_StatisticsPanel, imagePath, HorizontalAlignment.Right, false);
            }

            VdbNewContentViewModel logViewerContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_2_0_LogViewerHeader);
            {
                string imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/LogViewer.png");
                logViewerContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_LogViewerHeader, null, HorizontalAlignment.Right, true);
                logViewerContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_LogViewer, imagePath, HorizontalAlignment.Left, false);
            }

            VdbNewContentViewModel serverDiscoveryContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_1_0_ServerDiscoveryHeader);
            {
                string imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/ServerDiscovery.png");
                serverDiscoveryContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_ServerDiscoveryHeader, null, HorizontalAlignment.Left, true);
                serverDiscoveryContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_ServerDiscovery, imagePath, HorizontalAlignment.Right, false);
            }

            VdbNewContentViewModel uiContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_2_0_UiPanelHeader);
            {
                string imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/UiPanel.png");
                uiContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_UiPanelHeader, null, HorizontalAlignment.Left, true);
                uiContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_UiPanel, imagePath, HorizontalAlignment.Right, false);

                imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/RecentFiles.png");
                uiContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_RecentFilesHeader, null, HorizontalAlignment.Right, true);
                uiContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_RecentFiles, imagePath, HorizontalAlignment.Left, false);
            }

            VdbNewContentViewModel cameraContent = new VdbNewContentViewModel(Properties.Resources.WhatsNew_2017_2_0_CameraHeader);
            {
                string imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/CameraModes.png");
                cameraContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_CameraModesHeader, null, HorizontalAlignment.Right, true);
                cameraContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_CameraModes, imagePath, HorizontalAlignment.Left, false);

                imagePath = hkResourceUtils.GetResourcePath("Resources/WhatsNew/2017_2_0/PointOfInterest.png");
                cameraContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_PointOfInterestHeader, null, HorizontalAlignment.Left, true);
                cameraContent.AddContentParagraph(Properties.Resources.WhatsNew_2017_2_0_PointOfInterest, imagePath, HorizontalAlignment.Right, false);
            }

            VdbNewContentVersionedList contentList = new VdbNewContentVersionedList("2017.2");
            {
                contentList.Content.Add(statisticsPanelContent);
                contentList.Content.Add(logViewerContent);
                contentList.Content.Add(serverDiscoveryContent);
                contentList.Content.Add(uiContent);
                contentList.Content.Add(cameraContent);
            }

            DefaultContent = statisticsPanelContent;
            return contentList;
        }

        public VdbNewContentViewModel SelectedNewContentItem
        {
            get { return _SelectedNewContentItem; }
            set
            {
                if ((_SelectedNewContentItem != value) && (value != null))
                {
                    _SelectedNewContentItem = value;
                    NotifyPropertyChanged();
                }
            }
        }
        private VdbNewContentViewModel _SelectedNewContentItem;

        public bool IsNewContentPanelShown
        {
            get { return _IsNewContentPanelShown; }
            set
            {
                if (_IsNewContentPanelShown != value)
                {
                    _IsNewContentPanelShown = value;
                    NotifyPropertyChanged();
                }
            }
        }
        private bool _IsNewContentPanelShown;

        public bool NewContentPanelDontShowAgain
        {
            get
            {
                int whatsNewAckVersion = VdbSettings.GetValue<int>(nameof(Properties.Settings.VdbApp_WhatsNewAckVersion));
                return (whatsNewAckVersion >= m_owner.ClientSdkVersion);
            }

            set
            {
                // Dont Show Again
                if (value)
                {
                    VdbSettings.SetValue(nameof(Properties.Settings.VdbApp_WhatsNewAckVersion), m_owner.ClientSdkVersion);
                }
                else
                {
                    VdbSettings.SetValue(nameof(Properties.Settings.VdbApp_WhatsNewAckVersion), 0);
                }
            }
        }

        public ObservableCollection<VdbNewContentVersionedList> Content { get; private set; }
        public VdbNewContentViewModel DefaultContent { get; private set; }
        private VdbViewModel m_owner;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
