// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;

namespace HavokVisualDebugger
{
    public class VdbLogViewModel : ViewModelNotifyPropertyChanged
    {
        #region VdbLogViewModel Initialization
        public VdbLogViewModel(string text, Havok.Vdb.LogLevel level, long frame, Havok.Vdb.LogSource source, long absoluteFrame, int tag, ulong id)
        {
            m_timestamp = DateTime.Now;
            m_text = text.TrimEnd(new char[] { '\n', '\r' });
            m_level = level;
            m_frame = frame;
            m_source = source;
            m_absoluteFrame = absoluteFrame;
            m_tag = tag;
            m_id = id;
        }

        #endregion

        #region VdbLogViewModel View Commands and Properties

        public string LogFrame
        {
            get { return m_frame.ToString(); }
        }

        public long AbsoluteFrame
        {
            get { return m_absoluteFrame; }
        }

        public string LogText
        {
            get { return (m_text != null) ? m_text : ""; }
        }

        public string LogLevel
        {
            get { return m_level.ToString(); }
        }

        public string LogDisplayText
        {
            get { return $"{LogTimestamp}    {LogLevel}    {LogFrame}    {LogText}"; }
        }

        public Havok.Vdb.LogLevel LogLevelNative
        {
            get { return m_level; }
        }

        public string LogTimestamp
        {
            get { return m_timestamp.ToLongTimeString(); }
        }

        public Havok.Vdb.LogSource LogSource
        {
            get { return m_source; }
        }

        public string LogSourceDisplay
        {
            get { return m_source.ToString(); }
        }

        public bool IsSelected
        {
            get { return _IsSelected; }
            set
            {
                if (_IsSelected != value)
                {
                    _IsSelected = value;
                    NotifyPropertyChanged();
                }
            }
        }
        private bool _IsSelected;

        public bool IsServerDisabled
        {
            get { return m_tag == -1; }
        }
        
        #endregion

        #region VdbLogViewModel Private Methods and Properties
        private string m_text;
        private Havok.Vdb.LogLevel m_level;
        private long m_frame;
        private DateTime m_timestamp;
        private Havok.Vdb.LogSource m_source;
        private long m_absoluteFrame;
        private int m_tag;
        private ulong m_id;
        #endregion
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
