// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;

namespace HavokVisualDebugger
{

    public class VdbCameraViewModel : ViewModelNotifyPropertyChanged
    {
        #region VdbCameraViewModel Initialization
        public VdbCameraViewModel(Havok.Vdb.RenderSurface surface, string name, VdbViewModel owner)
        {
            m_surface = surface;
            m_name = name;
            m_owner = owner;
        }
        #endregion

        #region VdbCameraViewModel View Commands and Properties

        public string Name
        {
            get
            {
                return (!String.IsNullOrEmpty(m_name)) ? m_name.Trim() : Properties.Resources.Camera_Unknown;
            }
        }

        public bool IsSelected
        {
            get { return (m_surface.RenderCamera == m_name); }
            set
            {
                if (IsSelected != value)
                {
                    if (value)
                    {
                        m_surface.RenderCamera = m_name;
                    }
                    else
                    {
                        m_surface.RenderCamera = null;
                    }
                    m_owner.NotifyIfRenderServerCameraChanged();
                    NotifyPropertyChanged(nameof(IsSelected));
                }
            }
        }

        internal void NotifySelectionChanged()
        {
            if (IsSelected)
            {
                VdbSettings.SetValue(nameof(Properties.Settings.VdbCamera_SelectedCamera), Name);
            }
            NotifyPropertyChanged(nameof(IsSelected));
        }

        #endregion

        #region VdbCameraViewModel Private Methods and Properties
        Havok.Vdb.RenderSurface m_surface;
        private string m_name;
        VdbViewModel m_owner;
        #endregion
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
