// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbPlaybackWidget.xaml
    /// </summary>
    public partial class VdbPlaybackWidget : UserControl
    {
        public VdbPlaybackWidget()
        {
            try
            {
                InitializeComponent();
            }
            catch(Exception e)
            {
                // This makes it much easier to debug cryptic XAML exceptions
                Console.WriteLine("Exception Message: ");
                Console.WriteLine(e.Message);
                Console.WriteLine("Inner Exception Message: ");
                Console.WriteLine(e.InnerException.Message);
            }

            PlaybackSlider.ApplyTemplate();
            Thumb thumb = (PlaybackSlider.Template.FindName("PART_Track", PlaybackSlider) as Track).Thumb;
            thumb.MouseEnter += new MouseEventHandler(thumb_MouseEnter);
            thumb.DragStarted += delegate(Object sender, DragStartedEventArgs e)
            {
                VdbViewModel vm = (DataContext as VdbViewModel);
                vm.IsDraggingPlaybackThumb = true;
            };
            thumb.DragCompleted += delegate (Object sender, DragCompletedEventArgs e)
            {
                VdbViewModel vm = (DataContext as VdbViewModel);
                vm.IsDraggingPlaybackThumb = false;
            };
        }

        private void thumb_MouseEnter(object sender, MouseEventArgs e)
        {
            if (e.LeftButton == MouseButtonState.Pressed && e.MouseDevice.Captured == null)
            {
                MouseButtonEventArgs args = new MouseButtonEventArgs(e.MouseDevice, e.Timestamp, MouseButton.Left);
                args.RoutedEvent = MouseLeftButtonDownEvent;
                (sender as Thumb).RaiseEvent(args);
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
