// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Collections;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbObjectPropertiesPanel.xaml
    /// </summary>
    public partial class VdbObjectPropertiesPanel : UserControl
    {
        public VdbObjectPropertiesPanel()
        {
            InitializeComponent();
        }

        private void DataGrid_PreviewMouseWheel(object sender, MouseWheelEventArgs e)
        {
            if (!e.Handled)
            {
                e.Handled = true;
                var eventArg = new MouseWheelEventArgs(e.MouseDevice, e.Timestamp, e.Delta);
                eventArg.RoutedEvent = UIElement.MouseWheelEvent;
                eventArg.Source = sender;
                var parent = ((Control)sender).Parent as UIElement;
                parent.RaiseEvent(eventArg);
            }
        }


        private void CanCopy(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void Copy(object sender, ExecutedRoutedEventArgs e)
        {
            DataGrid dg = sender as DataGrid;
            if (dg != null)
            {
                IEnumerable entries = dg.SelectedItems;
                if (entries == null)
                {
                    return;
                }

                StringBuilder clipText = new StringBuilder();
                foreach (object propertyObj in entries)
                {
                    if (propertyObj == null || !(propertyObj is VdbObjectPropertyViewModel))
                    {
                        continue;
                    }

                    VdbObjectPropertyViewModel property = propertyObj as VdbObjectPropertyViewModel;
                    clipText.Append("".PadLeft(property.ParentPadding*2) + property.Name + ":\t" + property.Value + "\n" );
                }
                Clipboard.SetData(DataFormats.Text, clipText.ToString());
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
