// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Windows.Controls;
using System.Windows.Input;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbObjectInspectionWidget.xaml
    /// </summary>
    public partial class VdbObjectInspectionWidget : UserControl
    {
        public VdbObjectInspectionWidget()
        {
            InitializeComponent();
        }

        private void SearchComboBox_KeyDown(object sender, KeyEventArgs e)
        {
            VdbComboBox comboBox = (sender as VdbComboBox);
            if (comboBox != null)
            {
                VdbViewModel vm = (comboBox.DataContext as VdbViewModel);
                if (vm != null)
                {
                    if (e.Key == Key.Enter &&
                        Keyboard.Modifiers.HasFlag(ModifierKeys.Control))
                    {
                        vm.VdbObjectFilterLayers.CreateNewLayer();
                    }
                }
            }
        }

        private void SearchHelpButton_ToolTipClosing(object sender, ToolTipEventArgs e)
        {
            if( SearchHelpButton.IsMouseDirectlyOver )
            {
                ToolTip tooltip = (ToolTip)SearchHelpButton.ToolTip;
                tooltip.IsOpen = true;
                e.Handled = true;
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
