// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Windows.Controls;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbLogWidget.xaml
    /// </summary>
    public partial class VdbLogWidget : UserControl
    {
        public VdbLogWidget()
        {
            InitializeComponent();
        }
        
        private void TabControl_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            TabControl tab = e.Source as TabControl;
            if (tab != null && tab.DataContext is VdbViewModel )
            {
                VdbViewModel vm = tab.DataContext as VdbViewModel;
                vm.UnreadRemoteLogCount = vm.RemoteLogCollection.Count;
                vm.UnreadLocalLogCount = vm.LocalLogCollection.Count;
            }
        }

        private void TabControlRemote_LayoutUpdated(object sender, System.EventArgs e)
        {
            if (this.DataContext is VdbViewModel && RemoteTab.IsVisible && RemoteTab.IsSelected)
            {
                VdbViewModel vm = this.DataContext as VdbViewModel;
                vm.UnreadRemoteLogCount = vm.RemoteLogCollection.Count;
            }
        }

        private void TabControlLocal_LayoutUpdated(object sender, System.EventArgs e)
        {
            if (this.DataContext is VdbViewModel && LocalTab.IsVisible && LocalTab.IsSelected)
            {
                VdbViewModel vm = this.DataContext as VdbViewModel;
                vm.UnreadLocalLogCount = vm.LocalLogCollection.Count;
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
