// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections;
using System.Collections.Specialized;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Input;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbLogGridWidget.xaml
    /// </summary>
    public partial class VdbLogGridWidget : UserControl
    {
        public VdbLogGridWidget()
        {
            InitializeComponent();

            SelectedLogEntries.CollectionChanged += delegate (object sender, NotifyCollectionChangedEventArgs e)
            {
                if( e.NewItems != null )
                {
                    foreach( VdbLogViewModel logVm in e.NewItems )
                    {
                        logVm.IsSelected = true;
                    }
                }

                if (e.OldItems != null)
                {
                    foreach (VdbLogViewModel logVm in e.OldItems)
                    {
                        logVm.IsSelected = false;
                    }
                }
            };
        }

        public void Copy(object sender, ExecutedRoutedEventArgs e)
        {
            Copy(SelectedLogEntries);
        }

        public static void Copy(IEnumerable logEntries)
        {
            if (logEntries == null)
            {
                return;
            }
            
            StringBuilder clipText = new StringBuilder();
            foreach (VdbLogViewModel logEntry in logEntries)
            {
                if (logEntry == null)
                {
                    continue;
                }

                clipText.Append(string.Join(" ", new string[] { logEntry.LogTimestamp, logEntry.LogLevel, logEntry.LogText, "\n" }));
            }
            Clipboard.SetData(DataFormats.Text, clipText.ToString());
        }

        public void CanCopy(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }
        
        public void SelectAll(object sender, ExecutedRoutedEventArgs e)
        {
            SelectedLogEntries.Clear();
            foreach ( VdbLogViewModel logVm in LogEntryItemsControl.Items )
            {
                SelectedLogEntries.Add(logVm);
            }
        }

        public void CanSelectAll(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void Grid_PreviewMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            m_isSelecting = false;
        }

        private void Grid_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            object dc = (sender as FrameworkElement).DataContext;
            if (dc == BindingOperations.DisconnectedSource)
            {
                return;
            }

            VdbLogViewModel logVm = dc as VdbLogViewModel;
            if (logVm != null)
            {
                int logIndex = LogEntryItemsControl.Items.IndexOf(logVm);
                m_isSelecting = true;

                // Ctrl click toggles
                if (Keyboard.IsKeyDown(Key.LeftCtrl) || Keyboard.IsKeyDown(Key.RightCtrl))
                {
                    if (SelectedLogEntries.Contains(logVm))
                    {
                        // remove if already contains
                        SelectedLogEntries.Remove(logVm);
                    }
                    else
                    {
                        SelectedLogEntries.Add(logVm);
                    }
                    DominantSelectionIndex = logIndex;
                }

                // Shift click adds range
                else if (Keyboard.IsKeyDown(Key.LeftShift) || Keyboard.IsKeyDown(Key.RightShift))
                {
                    if (DominantSelectionIndex != -1)
                    {
                        SelectedLogEntries.Clear();

                        int minIndex = Math.Min(logIndex, DominantSelectionIndex);
                        int maxIndex = Math.Max(logIndex, DominantSelectionIndex);
                        for (int i = minIndex; i <= maxIndex; i++)
                        {
                            SelectedLogEntries.Add(LogEntryItemsControl.Items[i] as VdbLogViewModel);
                        }
                    }
                    else
                    {
                        SelectedLogEntries.Add(logVm);
                    }
                }

                // Normal click adds a single entry
                else
                {
                    SelectedLogEntries.Clear();
                    SelectedLogEntries.Add(logVm);
                    DominantSelectionIndex = logIndex;
                }
            }
        }

        private void Grid_MouseEnter(object sender, MouseEventArgs e)
        {
            if (!m_isSelecting)
            {
                return;
            }

            object dc = (sender as FrameworkElement)?.DataContext;
            if (dc == BindingOperations.DisconnectedSource)
            {
                return;
            }

            VdbLogViewModel logVm = dc as VdbLogViewModel;
            int logIndex = LogEntryItemsControl.Items.IndexOf(logVm);

            if( DominantSelectionIndex >= 0 )
            {
                if (Keyboard.IsKeyDown(Key.LeftShift) || Keyboard.IsKeyDown(Key.RightShift))
                {
                    SelectedLogEntries.Clear();
                }

                int minIndex = Math.Min(logIndex, DominantSelectionIndex);
                int maxIndex = Math.Max(logIndex, DominantSelectionIndex);
                for (int i = minIndex; i <= maxIndex; i++)
                {
                    VdbLogViewModel selectedLogVm = LogEntryItemsControl.Items[i] as VdbLogViewModel;
                    if (!SelectedLogEntries.Contains(selectedLogVm))
                    {
                        SelectedLogEntries.Add(selectedLogVm);
                    }
                }
            }
            else
            {
                if (!SelectedLogEntries.Contains(logVm))
                {
                    SelectedLogEntries.Add(logVm);
                }
                else
                {
                    SelectedLogEntries.Remove(logVm);
                }
            }
        }

        private hkNonResettableObservableCollection<VdbLogViewModel> SelectedLogEntries = new hkNonResettableObservableCollection<VdbLogViewModel>();
        private int DominantSelectionIndex = -1;
        private bool m_isSelecting = false;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
