// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbKeyboardShortcuts.xaml
    /// </summary>
    public partial class VdbKeyboardShortcuts : UserControl
    {
        public VdbKeyboardShortcuts()
        {
            InitializeComponent();
        }

        public void KeyboardShortcutsCancelBtn_Click(object sender, RoutedEventArgs e)
        {
            Visibility = Visibility.Collapsed;
        }

        private void VdbTextBox_PreviewKeyUp(object sender, KeyEventArgs e)
        {
            // The text box grabs all input.
            e.Handled = true;

            // Early out
            VdbViewModel viewModel = DataContext as VdbViewModel;
            if( viewModel == null )
            {
                System.Diagnostics.Debug.Assert(false, "Expected a VdbViewModel DataContext here, keyboard shortcuts need the correct DataContext set.  Shortcut won't be changed.");
                return;
            }

            TextBox tb = sender as TextBox;
            VdbShortcutViewModel shortcutViewModel = tb.DataContext as VdbShortcutViewModel;
            if(shortcutViewModel == null )
            {
                System.Diagnostics.Debug.Assert(false, "Expected a VdbShortcutViewModel DataContext on the TextBox, keyboard shortcuts need the correct DataContext set.  Shortcut won't be changed.");
                return;
            }

            // Fetch the actual shortcut key.
            Key key = (e.Key == Key.System ? e.SystemKey : e.Key);

            // Ignore modifier keys.
            if (key == Key.LeftShift || key == Key.RightShift ||
                key == Key.LeftCtrl || key == Key.RightCtrl ||
                key == Key.LeftAlt || key == Key.RightAlt ||
                key == Key.LWin || key == Key.RWin)
            {
                return;
            }

            shortcutViewModel.IsShortcutErrorShown = false;

            // Build the shortcut key name.
            StringBuilder shortcutText = new StringBuilder();
            if ((Keyboard.Modifiers & ModifierKeys.Control) != 0)
            {
                shortcutText.Append("Ctrl+");
            }
            if ((Keyboard.Modifiers & ModifierKeys.Shift) != 0)
            {
                shortcutText.Append("Shift+");
            }
            if ((Keyboard.Modifiers & ModifierKeys.Alt) != 0)
            {
                shortcutText.Append("Alt+");
            }
            shortcutText.Append(key.ToString());

            string newShortcut = shortcutText.ToString();
            string existingShortcut;
            if ((shortcutViewModel.Shortcut != newShortcut) && viewModel.HasShortcut(newShortcut, out existingShortcut))
            {
                // Early out of the shortcut exists already
                shortcutViewModel.ShortcutErrorText = string.Format(Properties.Resources.Commands_ShortcutExists, existingShortcut);
                return;
            }

            // Update the text box.
            shortcutViewModel.Shortcut = newShortcut;
        }

        private void TextBox_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            // The text box grabs all input.
            e.Handled = true;
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
