// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM		: WIN32 X64
// PRODUCT		: COMMON
// VISIBILITY	: CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace HavokVisualDebugger.Controls
{
    /// <summary>
    /// Interaction logic for VdbHeaderBar.xaml
    /// </summary>
    public partial class VdbHeaderBar : UserControl
    {
        public VdbHeaderBar()
        {
            InitializeComponent();
        }

        private void CloseButton_Click(object sender, RoutedEventArgs e)
        {
            Application.Current.Shutdown();
        }

        private void ResizeWindow()
        {
            if (Application.Current.MainWindow.WindowState == WindowState.Maximized)
            {
                Application.Current.MainWindow.WindowState = WindowState.Normal;
                MaxButton.Content = Application.Current.FindResource("MaximizeIcon") as String;
            }
            else
            {
                Application.Current.MainWindow.WindowState = WindowState.Maximized;
                MaxButton.Content = Application.Current.FindResource("UnmaximizeIcon") as String;
            }

            VdbSettings.SetValue(nameof(Properties.Settings.VdbUi_WindowMaximized), Application.Current.MainWindow.WindowState);
        }

        private void MaxButton_Click(object sender, RoutedEventArgs e)
        {
            ResizeWindow();
        }

        private void MinButton_Click(object sender, RoutedEventArgs e)
        {
            Application.Current.MainWindow.WindowState = WindowState.Minimized;
        }

        private void TitleBarHeader_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if (e.ChangedButton == MouseButton.Left)
            {
                if (e.ClickCount == 2)
                {
                    ResizeWindow();
                }
                else
                {
                    Application.Current.MainWindow.DragMove();
                }
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
