// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once



#include <Common/Base/Types/hkSignalSlots.h>

#include <VisualDebugger/VdbServices/Plugin/hkVdbPlugin.h>

class hkgDisplayContext;
class hkgWindow;
class hkgViewport;
class hkgCamera;
class hkgVdbPluginControl;
class hkgVdbWidgetManager;

//////////////////////////////////////////////////////////////////////////
/// A plugin which responds to graphics-related signals and draws the
/// results using hkg.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbPlugin : public hkVdbPlugin
{
public:
    
    hkgVdbPlugin();
    ~hkgVdbPlugin();

    //
    // hkVdbPlugin interface.
    //

    virtual hkResult init( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* dllErrorStream = HK_NULL ) HK_OVERRIDE;
    virtual hkResult quit() HK_OVERRIDE;
    virtual hkResult registerSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult unregisterSelf( hkVdbClient& client ) HK_OVERRIDE;
    virtual const char* getName() const { return "hkgVdbPlugin"; }

    //
    // Setup
    //

    /// Sets the window for the plugin to draw to.
    /// This must be set *before* the plugin is registered with any clients.
    void setWindow( hkgWindow& window );

    /// Gets the window the plugin is drawing to.
    hkgWindow* getWindow() const { return m_window; }

    //
    // Control
    //

    /// Allow the plugin to update, which it uses to handle input.
    hkResult update( hkgViewport& viewport );

    /// Render the plugin based on current state.
    /// You may optionally provide a renderCameraName from which to render.
    /// This camera name can be from the server or added directly to the hkgVdbCameraControl.
    /// For more detailed rendering, access hkgVdbPluginControl directly.
    void render( hkgViewport& viewport, const char* renderCameraName = HK_NULL ) const;

    /// A manager for hkgVdbWidgets (initialized after window is set).
    hkgVdbWidgetManager* getWidgetManager() { return m_manager; }

    /// More fine-grained control for the plugin (initialized after window is set).
    hkgVdbPluginControl* getControl() { return m_control; }

    //
    // Internal use
    //

    
    void onConnectingSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection, hkVdbSignalResult& result );

protected:

    hkBool32 isInitialized() const { return ( m_window && m_control && m_manager ); }

    
    hkRefPtr<hkVdbClient> m_client;
    hkRefPtr<hkgWindow> m_window;
    hkRefPtr<hkgVdbPluginControl> m_control;
    hkRefPtr<hkgVdbWidgetManager> m_manager;
};

class HK_EXPORT_VDB hkgVdbPluginApi
{
public:
    static hkRefNew<hkVdbPlugin> createVdbPlugin();
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
