// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPluginApi.h>

#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/DebugUtil/MultiThreadCheck/hkMultiThreadCheck.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>

#include <VisualDebugger/VdbDisplay/Hkg/System/hkgVdbPluginControl.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/hkgVdbWidgetManager.h>



#ifdef HK_DYNAMIC_DLL

// Feature stripping
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#define HK_EXCLUDE_LIBRARY_hkSceneData
#define HK_EXCLUDE_FEATURE_hkMonitorStream
#include <Common/Base/Config/hkProductFeatures.cxx>


//#include <VisualDebugger/VdbServices/_Auto/hkbBehaviorClassList.cxx>
//#define HK_CLASSES_FILE <Common/Base/ClassLists/hkPhysicsClassLists.cxx>
//#include <Common/Base/ClassLists/hkRegisterClasses.cxx>
//#include <Common/Base/System/Dll/hkDllMain.cxx>

#endif

#define DEBUG_LOG_IDENTIFIER "vdb.hkg"
#include <Common/Base/System/Log/hkLog.hxx>

hkgVdbPlugin::hkgVdbPlugin() : hkVdbPlugin( &s_debugLog ) { clearError(); }
hkgVdbPlugin::~hkgVdbPlugin() {}

hkResult hkgVdbPlugin::init( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream )
{
#ifdef HK_DYNAMIC_DLL
    hkResult result = HK_FAILURE;

    if ( baseSystemInfo.m_memoryRouter )
    {
        hkMemoryInitUtil::SyncInfo::syncLocalInitNodes( baseSystemInfo );

        result = hkBaseSystem::initNodes( &hkBaseSystem::InitNode::s_listHead );
        hkMonitorStream::init();

        if ( errorStream )
        {
            hkError::replaceInstance( errorStream );
            errorStream->addReference();
        }

        HK_ON_DEBUG_MULTI_THREADING( hkMultiThreadCheck::staticInit( hkMallocAllocator::m_defaultMallocAllocator ) );

        hkProductFeatures::initialize();
    }

    if ( result.isFailure() )
    {
        m_error = hkVdbError::PLUGIN_INIT_ERROR;
    }

    return result;
#else
    return HK_SUCCESS;
#endif
}

hkResult hkgVdbPlugin::quit()
{
    m_window = HK_NULL;
    m_control = HK_NULL;
    m_manager = HK_NULL;

    HK_VDB_VERIFY_OPERATION_MSG(
        hkBaseSystem::quit(),
        0xadb0015,
        hkVdbError::PLUGIN_QUIT_ERROR,
        "Failed to quit base system" );

    return HK_SUCCESS;
}

void hkgVdbPlugin::setWindow( hkgWindow& window )
{
    m_window = &window;
    m_control = hkRefNew<hkgVdbPluginControl>( new hkgVdbPluginControl( window ) );
    m_manager = hkRefNew<hkgVdbWidgetManager>( new hkgVdbWidgetManager( *this ) );
}

hkResult hkgVdbPlugin::update( hkgViewport& viewport )
{
    if ( isInitialized() )
    {
        HK_VDB_VERIFY_OPERATION( m_manager->update( viewport ), 0xadb0020, hkVdbError::PLUGIN_ERROR );
    }
    return HK_SUCCESS;
}

void hkgVdbPlugin::render( hkgViewport& viewport, const char* renderCameraName ) const
{
    if ( isInitialized() )
    {
        
        
        
        hkgDisplayContext& context = *m_window->getContext();
        context.lock();

        // Render view
        m_control->getCameraControl().render( viewport, renderCameraName );

        // Render 3d
        m_control->getGeometryControl().render( viewport );
        m_control->getDisplayControl().render( viewport );

        // Render widgets (3D widgets, then 2D widgets, then borders, then tooltips)
        m_manager->render(viewport);

        context.unlock();
    }
}

hkResult hkgVdbPlugin::registerSelf( hkVdbClient& client )
{
    HK_VDB_VERIFY_CONDITION_MSG(
        isInitialized(),
        0xadb0016,
        hkVdbError::PLUGIN_SETUP_INVALID,
        "You must provide the hkgVdbPlugin with a window before it can be registered (see setWindow)" );

    // We register the manager first because controls do reference some built-in widgets.
    HK_VDB_VERIFY_REPORTER_OPERATION( m_manager->registerSelf( *this, client ), *m_manager, hkVdbError::PLUGIN_SETUP_INVALID );
    HK_VDB_VERIFY_REPORTER_OPERATION( m_control->registerSelf( *this, client ), *m_control, hkVdbError::PLUGIN_SETUP_INVALID );

    HK_SUBSCRIBE_TO_SIGNAL( client.m_connecting, this, hkgVdbPlugin );

    m_client = &client;
    return HK_SUCCESS;
}

hkResult hkgVdbPlugin::unregisterSelf( hkVdbClient& client )
{
    m_client->m_connecting.unsubscribeAll( this );
    m_client = HK_NULL;

    HK_VDB_VERIFY_CONDITION_MSG(
        isInitialized(),
        0xadb0017,
        hkVdbError::PLUGIN_SETUP_INVALID,
        "The hkgVdbPlugin's window has been cleared, it cannot be unregistered" );

    HK_VDB_VERIFY_REPORTER_OPERATION( m_control->unregisterSelf( *this, client ), *m_control, hkVdbError::PLUGIN_SETUP_INVALID );
    HK_VDB_VERIFY_REPORTER_OPERATION( m_manager->unregisterSelf( *this, client ), *m_manager, hkVdbError::PLUGIN_SETUP_INVALID );

    return HK_SUCCESS;
}

void hkgVdbPlugin::onConnectingSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection, hkVdbSignalResult& result )
{
    if ( isInitialized() )
    {
        return;
    }

    HK_VDB_SIGNAL_ERROR_MSG(
        0xadb0018,
        hkVdbError::PLUGIN_SETUP_INVALID,
        "You must provide the hkgVdbPlugin with a window before it can respond to signals (see setWindow)" );

    result.signalError( *this );
}

hkRefNew<hkVdbPlugin> hkgVdbPluginApi::createVdbPlugin()
{
    return new hkgVdbPlugin();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
