// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

namespace hkgVdb
{
    namespace Detail
    {
        template <typename T1, typename T2>
        HK_INLINE hkgVdbBounds computeScaledBounds( const hkgVdbBounds& bounds, hkgVdbPointBase<T1> center, hkgVdbPointBase<T2> scales )
        {
            center.m_x = hkMath::clamp( center.m_x, T1( bounds.m_minX ), T1( bounds.m_maxX ) );
            center.m_y = hkMath::clamp( center.m_y, T1( bounds.m_minY ), T1( bounds.m_maxY ) );

            hkgVdbPoint tmin(
                hkInt32( -( center.m_x - bounds.m_minX ) * ( scales.m_x - 1.0 ) ),
                hkInt32( -( center.m_y - bounds.m_minY ) * ( scales.m_y - 1.0 ) ) );

            hkgVdbPoint tmax(
                hkInt32( ( bounds.m_maxX - center.m_x ) * ( scales.m_x - 1.0 ) ),
                hkInt32( ( bounds.m_maxY - center.m_y ) * ( scales.m_y - 1.0 ) ) );

            hkgVdbBounds scaledBounds(
                bounds.m_minX + tmin.m_x,
                bounds.m_maxX + tmax.m_x,
                bounds.m_minY + tmin.m_y,
                bounds.m_maxY + tmax.m_y
            );

            return scaledBounds;
        }

        template <typename T>
        HK_INLINE hkgVdbBounds computeTranslatedBounds( const hkgVdbBounds& bounds, hkgVdbPointBase<T> t )
        {
            return hkgVdbBounds(
                bounds.m_minX + hkInt32( t.m_x ),
                bounds.m_maxX + hkInt32( t.m_x ),
                bounds.m_minY + hkInt32( t.m_y ),
                bounds.m_maxY + hkInt32( t.m_y )
            );
        }
    }
}

template <typename T>
HK_INLINE hkBool32 hkgVdbBounds::isInside( hkgVdbPointBase<T> p ) const
{
    return ( m_minX <= p.m_x ) && ( p.m_x <= m_maxX ) && ( m_minY <= p.m_y ) && ( p.m_y <= m_maxY );
}

HK_INLINE hkBool32 hkgVdbBounds::contains( const hkgVdbBounds& other ) const
{
    return
        isInside( hkgVdbPoint( other.m_minX, other.m_minY ) ) &&
        isInside( hkgVdbPoint( other.m_maxX, other.m_maxY ) );
}

//HK_INLINE hkResult hkgVdbBounds::tryScale( hkgVdbPoint center, hkgVdbRealPoint scales )
//{
//  HK_ASSERT_NOT_IMPLEMENTED( 0 );
//  return HK_FAILURE;
//}

template <typename T>
hkResult hkgVdbBounds::tryTranslate( hkgVdbPointBase<T> t )
{
    hkgVdbBounds b = hkgVdb::Detail::computeTranslatedBounds( *this, t );

    // Don't apply scales if any would wrap
    if ( ( t.m_x > 0.0f ) && ( b.m_minX < m_minX ) || ( t.m_x < 0.0f ) && ( m_minX < b.m_minX ) ||
        ( t.m_y > 0.0f ) && ( b.m_minY < m_minY ) || ( t.m_y < 0.0f ) && ( m_minY < b.m_minY ) )
    {
        return HK_FAILURE;
    }
    else
    {
        ( *this ) = b;
        return HK_SUCCESS;
    }
}

template <typename T1, typename T2>
HK_INLINE void hkgVdbBounds::scale( hkgVdbPointBase<T1> center, hkgVdbPointBase<T2> scales )
{
    ( *this ) = hkgVdb::Detail::computeScaledBounds( *this, center, scales );
}

template <typename T>
HK_INLINE void hkgVdbBounds::translate( hkgVdbPointBase<T> t )
{
    ( *this ) = hkgVdb::Detail::computeTranslatedBounds( *this, t );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
