// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbDisplay/Hkg/System/Control/hkgVdbGeometryControl.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Control/hkgVdbDisplayControl.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Control/hkgVdbCameraControl.h>

class hkgWindow;
class hkVdbClient;
class hkgVdbPlugin;

//////////////////////////////////////////////////////////////////////////
/// Container for various controls for the plugin.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbPluginControl : public hkVdbDefaultErrorReporter
{
public:
    HK_DECLARE_CLASS( hkgVdbPluginControl, New );
    hkgVdbPluginControl( hkgWindow& window );
    ~hkgVdbPluginControl();

    //
    // Registration
    //

    hkResult registerSelf( hkgVdbPlugin& plugin, hkVdbClient& client );
    hkResult unregisterSelf( hkgVdbPlugin& plugin, hkVdbClient& client );

    //
    //  Controls
    //

    /// Get the control for geometry in the display world.
    hkgVdbGeometryControl& getGeometryControl() { return m_geometryControl; }

    /// Get the control for immediate-mode-display in the display world.
    hkgVdbDisplayControl& getDisplayControl() { return m_displayControl; }

    /// Get the control for cameras in the display world.
    hkgVdbCameraControl& getCameraControl() { return m_cameraControl; }

protected:

    hkgVdbGeometryControl m_geometryControl;
    hkgVdbDisplayControl m_displayControl;
    hkgVdbCameraControl m_cameraControl;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
