// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/hkgVdbPluginControl.h>

#include <Graphics/Common/Window/hkgWindow.h>

#include <VisualDebugger/VdbServices/hkVdbClient.h>

#define DEBUG_LOG_IDENTIFIER "vdb.hkg.System.Control"
#include <Common/Base/System/Log/hkLog.hxx>

hkgVdbPluginControl::hkgVdbPluginControl( hkgWindow& window ) :
    hkVdbDefaultErrorReporter( &s_debugLog ),
    m_geometryControl( window ),
    m_displayControl( window ),
    m_cameraControl( window, m_geometryControl )
{}

hkgVdbPluginControl::~hkgVdbPluginControl()
{}

hkResult hkgVdbPluginControl::registerSelf( hkgVdbPlugin& plugin, hkVdbClient& client )
{
    if ( hkVdbDisplayHandler* displayHandler = client.getCmdHandler<hkVdbDisplayHandler>() )
    {
        bool succeeded = true;
        succeeded &= ( m_geometryControl.registerSelf( plugin, *displayHandler, client ).isSuccess() );
        succeeded &= ( m_displayControl.registerSelf( plugin, *displayHandler, client ).isSuccess() );
        succeeded &= ( m_cameraControl.registerSelf( plugin, *displayHandler, client ).isSuccess() );
        return succeeded ? HK_SUCCESS : HK_FAILURE;
    }

    HK_VDB_SIGNAL_ERROR_MSG( 0xadb00006, hkVdbError::PLUGIN_INIT_ERROR, "Client did not have display handler" );
    return HK_FAILURE;
}

hkResult hkgVdbPluginControl::unregisterSelf( hkgVdbPlugin& plugin, hkVdbClient& client )
{
    if ( hkVdbDisplayHandler* displayHandler = client.getCmdHandler<hkVdbDisplayHandler>() )
    {
        bool succeeded = true;
        succeeded &= ( m_geometryControl.unregisterSelf( plugin, *displayHandler, client ).isSuccess() );
        succeeded &= ( m_displayControl.unregisterSelf( plugin, *displayHandler, client ).isSuccess() );
        succeeded &= ( m_cameraControl.unregisterSelf( plugin, *displayHandler, client ).isSuccess() );
        return succeeded ? HK_SUCCESS : HK_FAILURE;
    }

    HK_VDB_SIGNAL_ERROR_MSG( 0xadb00007, hkVdbError::PLUGIN_QUIT_ERROR, "Client did not have display handler" );
    return HK_FAILURE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
