// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>

class hkgViewport;
class hkgInputManager;
class hkgVdbPlugin;
class hkVdbClient;
class hkgVdb2dWidget;

//////////////////////////////////////////////////////////////////////////
/// Defines a widget.
/// Widgets can be used as a generalized way to respond to inputs and drawn
/// in the hkgVdbPlugin.
/// Widgets exist as part of the hkgVdbWidgetManager.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbWidget : public hkVdbDefaultErrorReporter
{
public:
    HK_DECLARE_CLASS( hkgVdbWidget, Reflect, ReflectDetails( parents = false, specials = false, fields = false ) );
    hkgVdbWidget();

    /// Called for the widget to initialize itself.
    /// This is done during system initialization.
    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) = 0;

    /// Called for the widget to uninitialize (should undo actions in initialize).
    /// This is done during system tear-down.
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) = 0;

    /// Called for the widget to update its state (often where input handling should occur).
    virtual hkResult update( const hkgViewport& viewport, const hkgInputManager& input ) { return HK_SUCCESS; }

    /// Called for the widget to render based on current state.
    virtual void render( hkgDisplayContext& context ) const {}

    /// Get a tooltip for the widget.
    virtual void getToolTip( hkStringBuf& toolTipOut, bool verbose ) const {}

    
    /// Return the types of input this widget supports.
    virtual hkgVdbInputTypes getSupportedInputs() const { return hkgVdbInputTypes::NONE; }

    /// Return the input capabilities this widget supports.
    virtual hkgVdbInputCapabilities getInputCapabilities() const { return hkgVdbInputCapabilities::NONE; }

    /// Returns the inputs that are currently enabled for the widget by the widget manager.
    hkgVdbInputTypes getEnabledInputs() const { return m_enabledInputs; }
    

    /// Returns if the widget is currently enabled.
    /// Only enabled widgets get update/render, etc. calls from the widget manager.
    const hkBool32 getEnabled() const { return m_enabled; }

    /// Sets if the widget is currently enabled.
    /// Only enabled widgets get update/render, etc. calls from the widget manager.
    hkResult setEnabled( hkBool32 isEnabled )
    {
        if ( m_enabled != isEnabled )
        {
            m_enabled = isEnabled;
            if ( m_enabled )
            {
                return enable();
            }
            else
            {
                return disable();
            }
        }
        return HK_SUCCESS;
    }

protected:

    /// Called when the widget gets enabled.
    /// Widgets should do any actions they need to in order to start
    /// dealing with update, render, etc. calls.
    virtual hkResult enable() { return HK_SUCCESS; }

    /// Called when the widget gets disabled.
    /// Widgets should cleanup any setup done during enable().
    virtual hkResult disable() { return HK_SUCCESS; }

    
    /// Called when the widget manager determines the widget will
    /// be able to respond to some inputs. The widget can optionally
    /// capture any inputs they do not wish to go to any other widgets.
    virtual hkgVdbInputTypes captureInputs(
        const hkgViewport& viewport,
        const hkgInputManager& input,
        hkgVdb2dWidget* widgetUnderMouse,
        hkgVdbInputTypes enabledInputs );
    

    /// Acquires the render lock. Should be called in situations where process thread
    /// and render thread might be accessing the same information.
    /// Should not be called before initialized.
    
    
    
    
    HK_INLINE void acquireRenderLock() const { HK_ASSERT( 0x22441444, m_context, "Cannot call this before initialization" ); m_context->lock(); }

    /// Releases the render lock (see acquireRenderLock()).
    HK_INLINE void releaseRenderLock() const { HK_ASSERT( 0x22441445, m_context, "Cannot call this before initialization" ); m_context->unlock(); }

private:

    hkgVdbInputTypes setEnabledInputs(
        const hkgViewport& viewport,
        const hkgInputManager& input,
        hkgVdb2dWidget* widgetUnderMouse,
        hkgVdbInputTypes enabledInputs );

    void setContext( hkgDisplayContext* context ) { m_context = context; }

    hkBool32 m_enabled;
    hkgVdbInputTypes m_capturedInputs;
    hkgVdbInputTypes m_enabledInputs;
    hkRefPtr<hkgDisplayContext> m_context;
    friend class hkgVdbWidgetManager;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
