// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/hkgVdbWidget.h>

#include <Graphics/Common/Window/hkgWindow.h>

#define DEBUG_LOG_IDENTIFIER "vdb.hkg.System.Widget"
#include <Common/Base/System/Log/hkLog.hxx>

hkgVdbWidget::hkgVdbWidget() :
    hkVdbDefaultErrorReporter( &s_debugLog ),
    m_enabled( 0 ),
    m_capturedInputs( 0 ),
    m_enabledInputs( 0 )
{}

hkgVdbInputTypes hkgVdbWidget::setEnabledInputs(
    const hkgViewport& viewport,
    const hkgInputManager& input,
    hkgVdb2dWidget* widgetUnderMouse,
    hkgVdbInputTypes enabledInputs )
{
    m_capturedInputs = captureInputs( viewport, input, widgetUnderMouse, enabledInputs );
    HK_ASSERT( 0x22441099, m_capturedInputs.noneIsSet( ~enabledInputs ), "Some disabled types are captured" );
    m_enabledInputs = enabledInputs;
    m_capturedInputs.setWithMask( m_capturedInputs, enabledInputs );
    return m_capturedInputs;
}

hkgVdbInputTypes hkgVdbWidget::captureInputs(
    const hkgViewport& viewport,
    const hkgInputManager& input,
    hkgVdb2dWidget* widgetUnderMouse,
    hkgVdbInputTypes enabledInputs )
{
    // Capture the mouse if it's pressed and enabled.
    // Capture the keyboard if enabled.
    enabledInputs.andWith( bool( input.getMouse().getButtonState() ) * hkgVdbInputTypes::MOUSE | hkgVdbInputTypes::KEYBOARD );
    return enabledInputs;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
