// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Graphics\Common\Font\hkgFontDefines.h>

class hkgFont;
class hkgDisplayContext;

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdbTextBoxDrawer.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkgVdbTextBoxDrawerOptions : public hkgVdbDimensions
{
    HK_DECLARE_CLASS( hkgVdbTextBoxDrawerOptions, New );

    hkgVdbTextBoxDrawerOptions( hkgFont& font ) :
        m_textColor( hkColor::WHITESMOKE ),
        m_upperLeftColor( hkColor::rgbFromFloats( 0.14f, 0.14f, 0.16f, 0.9f ) ),
        m_lowerRightColor( hkColor::rgbFromFloats( 0.1f, 0.1f, 0.16f, 0.9f ) ),
        m_borderColor( hkColor::BLACK ),
        m_font( &font )
    {
        // By default, allow the text drawer to determine width/height
        m_width = m_height = 0;
        m_widthFraction = m_heightFraction = 0;
    }

    /// The color of the text.
    hkColor::Argb m_textColor;

    /// A color for the upper left corner of the box (creates gradient to lower right corner).
    hkColor::Argb m_upperLeftColor;

    /// A color for the lower right corner of the box (creates gradient to upper left corner).
    hkColor::Argb m_lowerRightColor;

    /// A color for the box border.
    hkColor::Argb m_borderColor;

    /// A font to use for the text.
    hkgFont* m_font;
};

//////////////////////////////////////////////////////////////////////////
/// Functions for drawing text boxes.
//////////////////////////////////////////////////////////////////////////
namespace hkgVdbTextBoxDrawer
{
    /// Get the bounds needed to draw the text with the provided options.
    HK_EXPORT_VDB HK_INLINE hkgVdbBounds getBounds( hkgViewport* viewport, const char* text, const hkgVdbTextBoxDrawerOptions& options )
    {
        hkgVdbBounds b;
        if ( options.m_font ) b.set( viewport, options, *options.m_font, text );
        return b;
    }

    /// Draw the text with the provided options and return the bounds of that text.
    HK_EXPORT_VDB hkgVdbBounds drawTextBox( hkgDisplayContext& context, const char* text, const hkgVdbTextBoxDrawerOptions& options );

    /// Load the default font for use with the text box drawer.
    HK_EXPORT_VDB hkRefNew<hkgFont> loadDefaultFont( hkgDisplayContext& context, int fontSize );

    /// Retrieve a reference table showing character values to rendered character (when drawn).
    HK_EXPORT_VDB const char* getCharacterReferenceTable();
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
