// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbTextBoxDrawer.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Window/hkgViewport.h>
#include <Graphics/Common/Camera/hkgCamera.h>
#include <Graphics/Common/Font/hkgFont.h>

#if defined(_WIN32) && !defined(__HAVOK_PARSER__)
#   include <windows.h>
#endif

namespace hkgVdbTextBoxDrawer
{
    hkgVdbBounds drawTextBox( hkgDisplayContext& context, const char* text, const hkgVdbTextBoxDrawerOptions& options )
    {
        hkgVdbBounds textExtents;

        if ( !text || ( *text ) == '\0' || !options.m_font )
        {
            return textExtents;
        }

        HKG_TIMER_BEGIN( "hkgVdbTextBoxDrawer::drawTextBox", this );

        HKG_TIMER_BEGIN( "BoundingBox", this )

        // Find the extents of the text
        hkgViewport* v = context.getCurrentViewport();
        textExtents = getBounds( v, text, options );

        // Draw an alpha background overlay
        {
            float p[3]; p[2] = -0.01f; //depth (0..-2)
            float tl[2]; float lr[2];
            const int border = 5;

            tl[0] = ( float ) textExtents.m_minX - border;
            tl[1] = ( float ) v->getHeight() - textExtents.m_minY + border;
            lr[0] = ( float ) textExtents.m_maxX + border;
            lr[1] = ( float ) v->getHeight() - textExtents.m_maxY - border;

            float upperLeftColor[4] =
            {
                hkColor::getRedAsFloat( options.m_upperLeftColor ),
                hkColor::getGreenAsFloat( options.m_upperLeftColor ),
                hkColor::getBlueAsFloat( options.m_upperLeftColor ),
                hkColor::getAlphaAsFloat( options.m_upperLeftColor ),
            };

            float lowerRightColor[4] =
            {
                hkColor::getRedAsFloat( options.m_lowerRightColor ),
                hkColor::getGreenAsFloat( options.m_lowerRightColor ),
                hkColor::getBlueAsFloat( options.m_lowerRightColor ),
                hkColor::getAlphaAsFloat( options.m_lowerRightColor ),
            };

            if ( ( upperLeftColor[3] != 0.0f ) || ( lowerRightColor[3] != 0.0f ) )
            {
                context.setCurrentColor4( upperLeftColor );
                context.beginGroup( HKG_IMM_TRIANGLE_LIST );
                p[0] = tl[0]; p[1] = tl[1];
                context.setCurrentPosition( p );
                p[0] = tl[0]; p[1] = lr[1];
                context.setCurrentPosition( p );
                p[0] = lr[0]; p[1] = tl[1];
                context.setCurrentPosition( p );
                p[0] = lr[0]; p[1] = tl[1];
                context.setCurrentPosition( p );
                p[0] = tl[0]; p[1] = lr[1];
                context.setCurrentPosition( p );
                p[0] = lr[0]; p[1] = lr[1];
                context.setCurrentColor4( lowerRightColor );
                context.setCurrentPosition( p );
                context.endGroup();
            }

            float borderColor[4] =
            {
                hkColor::getRedAsFloat( options.m_borderColor ),
                hkColor::getGreenAsFloat( options.m_borderColor ),
                hkColor::getBlueAsFloat( options.m_borderColor ),
                hkColor::getAlphaAsFloat( options.m_borderColor )
            };

            if ( borderColor[3] != 0.0f )
            {
                context.setCurrentColor4( borderColor );
                context.beginGroup( HKG_IMM_LINES );
                p[0] = tl[0]; p[1] = tl[1];
                context.setCurrentPosition( p );
                p[0] = tl[0]; p[1] = lr[1];
                context.setCurrentPosition( p );
                context.setCurrentPosition( p );
                p[0] = lr[0]; p[1] = lr[1];
                context.setCurrentPosition( p );
                context.setCurrentPosition( p );
                p[0] = lr[0]; p[1] = tl[1];
                context.setCurrentPosition( p );
                context.setCurrentPosition( p );
                p[0] = tl[0]; p[1] = tl[1];
                context.setCurrentPosition( p );
                context.endGroup();
            }
        }

        HKG_TIMER_END();

        context.setTexture2DState( true );

        // Ensure text is buffered from the dead zone
        hkUint32 textX = options.m_x;
        hkUint32 textY = options.m_y;
        if ( hkgWindow* window = context.getOwner() )
        {
            textX = hkMath::max2( 10 + window->getTVDeadZoneH(), textX );
            textY = hkMath::max2( 10 + window->getTVDeadZoneV(), textY );
        }

        // Flip y
        {
            int offset = int( v->getHeight() ) - int( options.m_font->getCharHeight() );
            textY = ( offset - textY );
        }

        // Render text
        {
            hkColor::Argb textColor = options.m_textColor;
            float tColor[4] = { hkColor::getRedAsFloat( textColor ), hkColor::getGreenAsFloat( textColor ), hkColor::getBlueAsFloat( textColor ), 1.0f };

            options.m_font->render( &context, text, float( textX ), float( textY ), tColor );
        }

        HKG_TIMER_END();

        return textExtents;
    }

    hkRefNew<hkgFont> loadDefaultFont( hkgDisplayContext& context, int fontSize )
    {
        context.lock();

        hkgFont* defaultFont = hkgFont::create();

        //if ( hkgSystem::getInstance().getRenderer() > hkgSystem::HKG_RENDERER_NULL )
        {

#if !defined(HK_PLATFORM_PSVITA) && !defined(HK_PLATFORM_ANDROID) && !defined(HK_PLATFORM_WIIU)  && !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)// enable Unicode TrueType fonts for other platforms. Works on NGP, just default fread stream is very slow to load at the moment
#ifdef HK_PLATFORM_WIN32
            char pathBuffer[MAX_PATH];
            GetWindowsDirectoryA( pathBuffer, MAX_PATH );
            hkStringBuf buf( pathBuffer, "\\Fonts\\courbd.ttf" );
            if ( !defaultFont->loadFontFromFile( &context, buf, fontSize) )
#endif
            {
                // Japanese + English:
                if ( !defaultFont->loadFontFromFile( &context, "./Resources/Common/Fonts/Sazanami/sazanami-gothic.ttf" ) )
                {
                    // Simple English only ASCII texture, not from TTF file
                    defaultFont->loadFromBuiltin( &context, false );
                }
            }
#else // no Unicode etc
            defaultFont->loadFromBuiltin( &context, false );
#endif
        }

        context.unlock();

        return defaultFont;
    }

    const char* getCharacterReferenceTable()
    {
        return ""
            "     0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | A | B | C | D | E | F \n"
            "00 - 0 | \x01 | \x02 | \x03 | \x04 | \x05 | \x06 | \x07 | \x08 | \x09 | \x0A | \x0B | \x0C | \x0D | \x0E | \x0F \n"
            "10 - \x10 | \x11 | \x12 | \x13 | \x14 | \x15 | \x16 | \x17 | \x18 | \x19 | \x1A | \x1B | \x1C | \x1D | \x1E | \x1F \n"
            "20 - \x20 | \x21 | \x22 | \x23 | \x24 | \x25 | \x26 | \x27 | \x28 | \x29 | \x2A | \x2B | \x2C | \x2D | \x2E | \x2F \n"
            "30 - \x30 | \x31 | \x32 | \x33 | \x34 | \x35 | \x36 | \x37 | \x38 | \x39 | \x3A | \x3B | \x3C | \x3D | \x3E | \x3F \n"
            "40 - \x40 | \x41 | \x42 | \x43 | \x44 | \x45 | \x46 | \x47 | \x48 | \x49 | \x4A | \x4B | \x4C | \x4D | \x4E | \x4F \n"
            "50 - \x50 | \x51 | \x52 | \x53 | \x54 | \x55 | \x56 | \x57 | \x58 | \x59 | \x5A | \x5B | \x5C | \x5D | \x5E | \x5F \n"
            "60 - \x60 | \x61 | \x62 | \x63 | \x64 | \x65 | \x66 | \x67 | \x68 | \x69 | \x6A | \x6B | \x6C | \x6D | \x6E | \x6F \n"
            "70 - \x70 | \x71 | \x72 | \x73 | \x74 | \x75 | \x76 | \x77 | \x78 | \x79 | \x7A | \x7B | \x7C | \x7D | \x7E | \x7F \n"
            "80 - \x80 | \x81 | \x82 | \x83 | \x84 | \x85 | \x86 | \x87 | \x88 | \x89 | \x8A | \x8B | \x8C | \x8D | \x8E | \x8F \n"
            "90 - \x90 | \x91 | \x92 | \x93 | \x94 | \x95 | \x96 | \x97 | \x98 | \x99 | \x9A | \x9B | \x9C | \x9D | \x9E | \x9F \n"
            "A0 - \xA0 | \xA1 | \xA2 | \xA3 | \xA4 | \xA5 | \xA6 | \xA7 | \xA8 | \xA9 | \xAA | \xAB | \xAC | \xAD | \xAE | \xAF \n"
            "B0 - \xB0 | \xB1 | \xB2 | \xB3 | \xB4 | \xB5 | \xB6 | \xB7 | \xB8 | \xB9 | \xBA | \xBB | \xBC | \xBD | \xBE | \xBF \n"
            "C0 - \xC0 | \xC1 | \xC2 | \xC3 | \xC4 | \xC5 | \xC6 | \xC7 | \xC8 | \xC9 | \xCA | \xCB | \xCC | \xCD | \xCE | \xCF \n"
            "D0 - \xD0 | \xD1 | \xD2 | \xD3 | \xD4 | \xD5 | \xD6 | \xD7 | \xD8 | \xD9 | \xDA | \xDB | \xDC | \xDD | \xDE | \xDF \n"
            "E0 - \xE0 | \xE1 | \xE2 | \xE3 | \xE4 | \xE5 | \xE6 | \xE7 | \xE8 | \xE9 | \xEA | \xEB | \xEC | \xED | \xEE | \xEF \n"
            "F0 - \xF0 | \xF1 | \xF2 | \xF3 | \xF4 | \xF5 | \xF6 | \xF7 | \xF8 | \xF9 | \xFA | \xFB | \xFC | \xFD | \xFE | \xFF";
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
