// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>
#include <Common/Base/Types/Geometry/Rect/hkRect.h>

//////////////////////////////////////////////////////////////////////////
/// A class representing stat bar graph functionality.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_COMMON hkgVdbStatBarGraph : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS( hkgVdbStatBarGraph, New );
        hkgVdbStatBarGraph();
        virtual ~hkgVdbStatBarGraph();

        /// Can call to resize too, but will wipe existing frame
        void init( const hkRectF& graphArea );

        struct Quad
        {
            hkStringPtr m_timerName;

            hkReal m_time;
            hkUint16 m_level;
            hkRectF m_rect;

            hkColor::Argb m_color;
            hkUint16 m_threadNum;

            const hkMonitorStreamParser::Node* m_srcNode;
            const hkGpuTraceResult* m_srcGpuResult;
        };

        struct Thread
        {
            Thread(const char* inName = HK_NULL, bool inCollapsed = false)
                : m_name(inName), m_collapsed(inCollapsed), m_height(0) {}
            hkStringPtr m_name;
            bool m_collapsed;
            hkReal m_height;
            hkArray<Quad> m_quads;
        };

        /// Use makeStatisticsTreeForSingleFrame in hkMonitorStream, with allowRoot as false so that all timers under proper owners
        /// Take all such Node for each thread/SPU etc and provide them here. Do not use any of the merge funcs in hkMonitorStream.
        /// Use startPos and endPos ( 0..1 of the time graph) to zoom, and thread to reduce to just a given thread of interest (for higher detail)
        /// Use ignoreFirstCalls to ignore the first N calls deep (so you can scroll a bit basically)
        void updateCpu( const hkArrayView<hkMonitorStreamParser::Tree*>& timers,
            int highlightNodeFlagMask = 0);

        /// Get the area that the graph will limit itself too
        const hkRectF& getGraphRect() const { return m_requestedRect; }

        /// Get a tight fitting bounding box around the timers
        const hkRectF& getActualRect() const { return m_actualRect; }

        const Quad* getQuadUnderPos( hkReal x, hkReal y ) const;

        hkMonitorStreamColorTable* getColorTable() { return m_colorTable; }
        void setColorTable(hkMonitorStreamColorTable* c);

        int getNumThreads() const;
        const Thread& getThread(int i) const;
        Thread& accessThread(int i);

        hkReal getGraphStartTime() const; // in ms
        hkReal getGraphEndTime() const; // in ms

    protected:

        hkRectF m_requestedRect;
        hkRectF m_actualRect;

        hkArray<Thread> m_threads;

        hkRefPtr<hkMonitorStreamColorTable> m_colorTable;

        hkReal m_frameTime;

        hkReal m_graphStartTime;
        hkReal m_graphEndTime;

public:
    static const int PIXELS_PER_LEVEL = 15;
    static const int MAX_PER_THREAD_STABLE_DEPTH = 12;
    static const int PIXELS_PER_MILLISECOND = 100;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
