// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Color/hkColor.h>

class hkgDisplayContext;

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdbAxisDrawer.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkgVdbAxisDrawerOptions
{
    HK_DECLARE_CLASS( hkgVdbAxisDrawerOptions, New );

    hkgVdbAxisDrawerOptions() :
        m_scale( 1.0f ),
        m_xColor( hkColor::RED ),
        m_yColor( hkColor::GREEN ),
        m_zColor( hkColor::BLUE )
    {}

    /// The scale used to draw the axis.
    hkReal m_scale;

    /// Color of x-axis.
    hkColor::Argb m_xColor;

    /// Color of y-axis.
    hkColor::Argb m_yColor;

    /// Color of z-axis.
    hkColor::Argb m_zColor;
};

//////////////////////////////////////////////////////////////////////////
/// Functions for drawing an axis.
//////////////////////////////////////////////////////////////////////////
namespace hkgVdbAxisDrawer
{
    /// Draws an xyz axis with the specified options in the current transform space of the context.
    HK_EXPORT_VDB void drawAxis( hkgDisplayContext& context, const hkgVdbAxisDrawerOptions& options );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
