// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbAxisDrawer.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>

namespace hkgVdbAxisDrawer
{
    const int NUM_X_AXIS_LINES = 5;
    const int NUM_Y_AXIS_LINES = 6;
    const int NUM_Z_AXIS_LINES = 6;
    const int NUM_AXIS_LINES = ( NUM_X_AXIS_LINES + NUM_Y_AXIS_LINES + NUM_Z_AXIS_LINES );

    static hkReal unitAxisLines[NUM_AXIS_LINES * 6] =
    {
        // -, >, X (5 Lines)
        0, 0, 0, 1, 0, 0,
        1, 0, 0, 0.85f, 0.1f, 0,
        1, 0, 0, 0.85f, -0.1f, 0,
        1.1f, 0.1f, 0, 1.2f, -0.1f, 0,
        1.2f, 0.1f, 0, 1.1f, -0.1f, 0,

        // -, >, Y (6 lines)
        0, 0, 0, 0, 1, 0,
        0, 1, 0, 0.1f, 0.85f, 0,
        0, 1, 0, -0.1f, 0.85f, 0,
        0.1f, 1.1f, 0, 0, 1.15f, 0,
        0.1f, 1.2f, 0, 0, 1.15f, 0,
        0, 1.15f, 0, -0.1f, 1.15f, 0,

        // -, >, Z (6 lines)
        0, 0, 0, 0, 0, 1,
        0, 0, 1, 0.1f, 0, 0.85f,
        0, 0, 1, -0.1f, 0, 0.85f,
        0.1f, 0, 1.1f, 0.1f, 0, 1.2f,
        0.1f, 0, 1.2f, -0.1f, 0, 1.1f,
        -0.1f, 0, 1.1f, -0.1f, 0, 1.2f,
    };

    void drawAxis( hkgDisplayContext& context, const hkgVdbAxisDrawerOptions& options )
    {
        context.beginGroup( HKG_IMM_LINES );
        hkReal *cp = unitAxisLines;
        hkReal vs[3];

        int i;
        for ( i = 0; i < NUM_X_AXIS_LINES; i++ )
        {
            context.setCurrentColorPacked( options.m_xColor );
            hkgVec3Mult( vs, cp, options.m_scale );
            context.setCurrentPosition( vs );
            cp += 3;
            hkgVec3Mult( vs, cp, options.m_scale );
            context.setCurrentColorPacked( options.m_xColor );
            context.setCurrentPosition( vs );
            cp += 3;
        }

        for ( i = 0; i < NUM_Y_AXIS_LINES; i++ )
        {
            context.setCurrentColorPacked( options.m_yColor );
            hkgVec3Mult( vs, cp, options.m_scale );
            context.setCurrentPosition( vs );
            cp += 3;
            context.setCurrentColorPacked( options.m_yColor );
            hkgVec3Mult( vs, cp, options.m_scale );
            context.setCurrentPosition( vs );
            cp += 3;
        }

        for ( i = 0; i < NUM_Z_AXIS_LINES; i++ )
        {
            context.setCurrentColorPacked( options.m_zColor );
            hkgVec3Mult( vs, cp, options.m_scale );
            context.setCurrentPosition( vs );
            cp += 3;
            context.setCurrentColorPacked( options.m_zColor );
            hkgVec3Mult( vs, cp, options.m_scale );
            context.setCurrentPosition( vs );
            cp += 3;
        }
        context.endGroup();
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
