// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Color/hkColor.h>

class hkgDisplayContext;

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdb3dBoxDrawer.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkgVdb3dBoxDrawerOptions
{
    HK_DECLARE_CLASS( hkgVdb3dBoxDrawerOptions, New );

    enum Style
    {
        /// Draws corner ticks around the box
        CORNERS,
        
        

        DEFAULT = CORNERS
    };

    hkgVdb3dBoxDrawerOptions() :
        m_style( DEFAULT ),
        m_color( hkColor::WHITESMOKE )
    {}

    /// The box style
    hkColor::Argb m_style;

    /// The color of the lines.
    hkColor::Argb m_color;
};

//////////////////////////////////////////////////////////////////////////
/// Functions for drawing 3d boxes.
//////////////////////////////////////////////////////////////////////////
namespace hkgVdb3dBoxDrawer
{
    /// Draw the box with the provided options and return the bounds of that text.
    HK_EXPORT_VDB void draw3dBox( hkgDisplayContext& context, const hkTransform& transform, const hkAabb& aabb, const hkgVdb3dBoxDrawerOptions& options );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
