// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdb3dBoxDrawer.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>

namespace hkgVdb3dBoxDrawer
{
    static float _cubeCornerMarkerLines[3 * 2 * 3 * 8] = {
        //0 (-,-,-)
        -0.01f, -0.01f, -0.01f, 0.25f, -0.01f, -0.01f,
        -0.01f, -0.01f, -0.01f, -0.01f, 0.25f, -0.01f,
        -0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.25f,
        //1 (-,-,+)
        1.01f, -0.01f, -0.01f, 0.75f, -0.01f, -0.01f,
        1.01f, -0.01f, -0.01f, 1.01f, 0.25f, -0.01f,
        1.01f, -0.01f, -0.01f, 1.01f, -0.01f, 0.25f,
        //2 (-,+,-)
        -0.01f, 1.01f, -0.01f, 0.25f, 1.01f, -0.01f,
        -0.01f, 1.01f, -0.01f, -0.01f, 0.75f, -0.01f,
        -0.01f, 1.01f, -0.01f, -0.01f, 1.01f, 0.25f,
        //3 (-,+,+)
        1.01f, 1.01f, -0.01f, 0.75f, 1.01f, -0.01f,
        1.01f, 1.01f, -0.01f, 1.01f, 0.75f, -0.01f,
        1.01f, 1.01f, -0.01f, 1.01f, 1.01f, 0.25f,
        //4 (+,-,-)
        -0.01f, -0.01f, 1.01f, 0.25f, -0.01f, 1.01f,
        -0.01f, -0.01f, 1.01f, -0.01f, 0.25f, 1.01f,
        -0.01f, -0.01f, 1.01f, -0.01f, -0.01f, 0.75f,
        //5 (+,-,+)
        1.01f, -0.01f, 1.01f, 0.75f, -0.01f, 1.01f,
        1.01f, -0.01f, 1.01f, 1.01f, 0.25f, 1.01f,
        1.01f, -0.01f, 1.01f, 1.01f, -0.01f, 0.75f,
        //6 (+,+,-)
        -0.01f, 1.01f, 1.01f, 0.25f, 1.01f, 1.01f,
        -0.01f, 1.01f, 1.01f, -0.01f, 0.75f, 1.01f,
        -0.01f, 1.01f, 1.01f, -0.01f, 1.01f, 0.75f,
        //7 (+,+,+)
        1.01f, 1.01f, 1.01f, 0.75f, 1.01f, 1.01f,
        1.01f, 1.01f, 1.01f, 1.01f, 0.75f, 1.01f,
        1.01f, 1.01f, 1.01f, 1.01f, 1.01f, 0.75f,
    };

    
    
    
    void draw3dBox( hkgDisplayContext& context, const hkTransform& transform, const hkAabb& aabb, const hkgVdb3dBoxDrawerOptions& options )
    {
        hkVector4 ac; aabb.getCenter( ac );
        hkVector4 ae; aabb.getHalfExtents( ae );
        hkVector4 le; le.setMul( hkSimdReal::fromFloat( 0.33f ), ae );
        hkVector4 se; se.setMul( hkSimdReal::fromFloat( 2.0f ), ae );

        context.setCurrentColorPacked( options.m_color );
        context.beginGroup( HKG_IMM_LINES );

        hkVector4 scaledCoords;
        hkVector4 xCoords;
        float* fCoords = _cubeCornerMarkerLines;
        for ( int c = 0; c < 8; ++c ) // eight corners
        {
            for ( int v = 0; v < 6; ++v ) // 3 lines, two verts each
            {
                hkVector4 coords; coords.load<3, HK_IO_NATIVE_ALIGNED>( fCoords );
                scaledCoords = ( coords * se ) - ae + ac;
                scaledCoords.setTransformedPos( transform, scaledCoords );
                fCoords += 3; // inc by 3 floats

                HK_ALIGN_REAL( float fscaledCoords[3] );
                scaledCoords.store<3, HK_IO_SIMD_ALIGNED>( fscaledCoords );
                context.setCurrentPosition( fscaledCoords );
            }
        }

        context.endGroup();
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
