// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/3d/hkgVdb3dWidget.h>

//////////////////////////////////////////////////////////////////////////
/// A widget facilitates viewport interaction.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbViewportWidget : public hkgVdb3dWidget
{
public:
    HK_DECLARE_CLASS( hkgVdbViewportWidget, New, ReflectIdentity );

    //
    // 3d Widget interface
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE { return HK_SUCCESS; }
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE { return HK_SUCCESS; }
    virtual hkgVdbInputTypes getSupportedInputs() const HK_OVERRIDE { return hkgVdbInputTypes::ALL; }
    virtual hkgVdbInputCapabilities getInputCapabilities() const HK_OVERRIDE { return hkgVdbInputCapabilities::MOUSE_WRAPPING; }
    virtual hkResult update( const hkgViewport& viewportIn, const hkgInputManager& input ) HK_OVERRIDE;
    virtual hkgVdbInputTypes captureInputs(
        const hkgViewport& viewport,
        const hkgInputManager& input,
        hkgVdb2dWidget* widgetUnderMouse,
        hkgVdbInputTypes enabledInputs );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
