// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/3d/hkgVdbViewportWidget.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/Window/hkgWindow.h>

hkResult hkgVdbViewportWidget::update( const hkgViewport& viewportIn, const hkgInputManager& input )
{
    // Apply enabled inputs to viewport
    hkgViewport& viewport = const_cast<hkgViewport&>( viewportIn );
    viewport.setAcceptsMouseEvents( getEnabledInputs().anyIsSet( hkgVdbInputTypes::MOUSE ) );
    viewport.setAcceptsPadEvents( getEnabledInputs().anyIsSet( hkgVdbInputTypes::MOUSE ) );
    viewport.setAcceptsKeyEvents( getEnabledInputs().anyIsSet( hkgVdbInputTypes::KEYBOARD ) );
    return HK_SUCCESS;
}

hkgVdbInputTypes hkgVdbViewportWidget::captureInputs( const hkgViewport& viewport,
    const hkgInputManager& input,
    hkgVdb2dWidget* widgetUnderMouse,
    hkgVdbInputTypes enabledInputs )
{
    // Viewport captures all its used inputs
    hkgVdbInputTypes capturedInputs = 0;
    const hkgMouse& mouse = input.getMouse();
    const hkgKeyboard& keyboard = input.getKeyboard();
    if ( mouse.getButtonState() )
    {
        capturedInputs.orWith( hkgVdbInputTypes::MOUSE & enabledInputs );
    }
    for ( int i = 0; i < 6; i++ )
    {
        capturedInputs.orWith( ( bool( keyboard.getKeyState( viewport.getMovementKeys()[i] ) ) * hkgVdbInputTypes::KEYBOARD ) & enabledInputs );
    }
    return capturedInputs;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
