// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkResult hkgVdbSelectionWidget::setPointOfInterest(
    hkUint64 id,
    hkVector4Parameter worldPosition,
    hkColor::Argb color,
    hk1PointDisplayStyle::Enum style,
    hkReal scale )
{
    HK_VDB_VERIFY_CONDITION_MSG(
        ( scale > 0 ) && ( color != hkColor::NONE ) && ( worldPosition.isOk<3>() ),
        0xadb00053,
        hkVdbError::INVALID_ARGUMENTS,
        "Some of the args were not valid for setPointOfInterest" );

    PointsOfInterestChangedInfo changedInfo;
    hkResult result = setPOIInternal(
        id,
        0,
        -1,
        worldPosition,
        color,
        style,
        scale,
        m_pointsOfInterest,
        changedInfo.m_addedToGlobal );
    if ( changedInfo.m_addedToGlobal.getSize() )
    {
        m_pointOfInterestChanged.fire( m_pointsOfInterest, changedInfo );
        
    }
    return result;
}

HK_INLINE hkResult hkgVdbSelectionWidget::setLocalPointOfInterest(
    hkUint64 id,
    hkUint64 geometryId,
    int subGeomIdx,
    hkVector4Parameter localPosition,
    hkColor::Argb color,
    hk1PointDisplayStyle::Enum style,
    hkReal scale )
{
    HK_VDB_VERIFY_CONDITION_MSG(
        geometryId && ( scale > 0 ) && ( color != hkColor::NONE ) && ( localPosition.isOk<3>() ),
        0xadb00054,
        hkVdbError::INVALID_ARGUMENTS,
        "Some of the args were not valid for setLocalPointOfInterest" );

    PointsOfInterestChangedInfo changedInfo;
    hkResult result = setPOIInternal(
        id,
        geometryId,
        subGeomIdx,
        localPosition,
        color,
        style,
        scale,
        m_pointsOfInterest,
        changedInfo.m_addedToLocal );
    if ( changedInfo.m_addedToLocal.getSize() )
    {
        m_pointOfInterestChanged.fire( m_pointsOfInterest, changedInfo );
        
    }
    return result;
}

HK_INLINE bool hkgVdbSelectionWidget::clearPointsOfInterest( hkArrayView<hkUint64> ids )
{
    PointsOfInterestChangedInfo changedInfo;
    if ( clearPOIsInternal(
        ids,
        m_pointsOfInterest,
        changedInfo.m_removedFromGlobal,
        changedInfo.m_removedFromLocal ) )
    {
        m_pointOfInterestChanged.fire( m_pointsOfInterest, changedInfo );
        
        return true;
    }
    else
    {
        return false;
    }
}

HK_INLINE const hkgVdbSelectionWidget::PointOfInterest* hkgVdbSelectionWidget::getPointOfInterest( hkUint64 id ) const
{
    auto iter = m_pointsOfInterest.findKey( id );
    return ( m_pointsOfInterest.isValid( iter ) ) ? &m_pointsOfInterest.getValue( iter ) : HK_NULL;
}

HK_INLINE const hkgVdbSelectionWidget::PointsOfInterest& hkgVdbSelectionWidget::getPointsOfInterest() const
{
    return m_pointsOfInterest;
}

HK_INLINE hkResult hkgVdbSelectionWidget::highlightGeometry( hkUint64 id )
{
    return highlightGeometries( hkArrayViewT::fromSingleObject( id ) );
}

HK_INLINE hkResult hkgVdbSelectionWidget::highlightGeometries( hkArrayView<hkUint64> ids )
{
    return highlightSetInternal<GeometrySetIdx>( ids );
}

HK_INLINE const hkgVdbSelectionWidget::SelectionSet& hkgVdbSelectionWidget::getHighlightedGeometries() const
{
    return getHighlightedSetInternal<GeometrySetIdx>();
}

HK_INLINE bool hkgVdbSelectionWidget::clearHighlightedGeometries( hkArrayView<hkUint64> ids )
{
    return clearHighlightedSetInternal<GeometrySetIdx>( ids );
}

HK_INLINE hkResult hkgVdbSelectionWidget::selectGeometry( hkUint64 id )
{
    return selectGeometries( hkArrayViewT::fromSingleObject( id ) );
}

HK_INLINE hkResult hkgVdbSelectionWidget::selectGeometries( hkArrayView<hkUint64> ids )
{
    return selectSetInternal<GeometrySetIdx>( ids );
}

HK_INLINE const hkgVdbSelectionWidget::SelectionSet& hkgVdbSelectionWidget::getSelectedGeometries() const
{
    return getSelectedSetInternal<GeometrySetIdx>();
}

HK_INLINE bool hkgVdbSelectionWidget::clearSelectedGeometries( hkArrayView<hkUint64> ids )
{
    return clearSelectedSetInternal<GeometrySetIdx>( ids );
}

HK_INLINE hkResult hkgVdbSelectionWidget::highlightDisplay( hkUint64 id )
{
    return highlightDisplays( hkArrayViewT::fromSingleObject( id ) );
}

HK_INLINE hkResult hkgVdbSelectionWidget::highlightDisplays( hkArrayView<hkUint64> ids )
{
    return highlightSetInternal<DisplaySetIdx>( ids );
}

HK_INLINE const hkgVdbSelectionWidget::SelectionSet& hkgVdbSelectionWidget::getHighlightedDisplays() const
{
    return getHighlightedSetInternal<DisplaySetIdx>();
}

HK_INLINE bool hkgVdbSelectionWidget::clearHighlightedDisplays( hkArrayView<hkUint64> ids )
{
    return clearHighlightedSetInternal<DisplaySetIdx>( ids );
}

HK_INLINE hkResult hkgVdbSelectionWidget::selectDisplay( hkUint64 id )
{
    return selectDisplays( hkArrayViewT::fromSingleObject( id ) );
}

HK_INLINE hkResult hkgVdbSelectionWidget::selectDisplays( hkArrayView<hkUint64> ids )
{
    return selectSetInternal<DisplaySetIdx>( ids );
}

HK_INLINE const hkgVdbSelectionWidget::SelectionSet& hkgVdbSelectionWidget::getSelectedDisplays() const
{
    return getSelectedSetInternal<DisplaySetIdx>();
}

HK_INLINE bool hkgVdbSelectionWidget::clearSelectedDisplays( hkArrayView<hkUint64> ids )
{
    return clearSelectedSetInternal<DisplaySetIdx>( ids );
}

template<int IDX>
HK_INLINE hkResult hkgVdbSelectionWidget::highlightSetInternal( hkArrayView<hkUint64> ids )
{
    SelectionChangedInfo changedInfo;
    hkResult result = addToSetInternal<IDX>(
        ids,
        m_selectionSets[IDX].m_highlighted,
        changedInfo.m_addedToHighlighted );
    if ( changedInfo.m_addedToHighlighted.getSize() )
    {
        signalSelectionChangedInternal<IDX>( changedInfo );
    }
    return result;
}

template<int IDX>
HK_INLINE const hkgVdbSelectionWidget::SelectionSet& hkgVdbSelectionWidget::getHighlightedSetInternal() const
{
    return m_selectionSets[IDX].m_highlighted;
}

template<int IDX>
HK_INLINE bool hkgVdbSelectionWidget::clearHighlightedSetInternal( hkArrayView<hkUint64> ids )
{
    SelectionChangedInfo changedInfo;
    if ( removeFromSetInternal(
        ids,
        m_selectionSets[IDX].m_highlighted,
        changedInfo.m_removedFromHighlighted,
        &m_selectionSets[IDX].m_selected,
        &changedInfo.m_removedFromSelected ) )
    {
        signalSelectionChangedInternal<IDX>( changedInfo );
        return true;
    }
    else
    {
        return false;
    }
}

template<int IDX>
HK_INLINE hkResult hkgVdbSelectionWidget::selectSetInternal( hkArrayView<hkUint64> ids )
{
    SelectionChangedInfo changedInfo;
    hkResult result = addToSetInternal<IDX>(
        ids,
        m_selectionSets[IDX].m_selected,
        changedInfo.m_addedToSelected,
        &m_selectionSets[IDX].m_highlighted,
        &changedInfo.m_addedToHighlighted );
    if ( changedInfo.m_addedToHighlighted.getSize() || changedInfo.m_addedToSelected.getSize() )
    {
        signalSelectionChangedInternal<IDX>( changedInfo );
    }
    return result;
}

template<int IDX>
HK_INLINE const hkgVdbSelectionWidget::SelectionSet& hkgVdbSelectionWidget::getSelectedSetInternal() const
{
    return m_selectionSets[IDX].m_selected;
}

template<int IDX>
HK_INLINE bool hkgVdbSelectionWidget::clearSelectedSetInternal( hkArrayView<hkUint64> ids )
{
    SelectionChangedInfo changedInfo;
    if ( removeFromSetInternal(
        ids,
        m_selectionSets[IDX].m_selected,
        changedInfo.m_removedFromSelected ) )
    {
        signalSelectionChangedInternal<IDX>( changedInfo );
        return true;
    }
    else
    {
        return false;
    }
}

template<int IDX>
hkResult hkgVdbSelectionWidget::addToSetInternal(
    hkArrayView<hkUint64> ids,
    SelectionSet& set,
    SelectionSet& addedOut,
    SelectionSet* setFilter,
    SelectionSet* setFilterAddedOut )
{
    hkBool32 succeeded = true;

    for ( int i = 0; i < ids.getSize(); i++ )
    {
        const hkUint64 id = ids[i];
        SelectionSet::Iterator iter = set.findOrInsertKey( id, m_dummyObj );
        if ( set.getValue( iter ) == m_dummyObj )
        {
            
            hkBool32 updateFilter = false;
            hkBool32 containedInFilter = ( !setFilter || ( setFilter->getSize() == 0 ) || setFilter->contains( id ) );
            if ( !containedInFilter )
            {
                
                
                //if ( m_selectionFlags.anyIsSet( hkgVdbSelectionFlags::CLEAR_ON_UNHIGHLIGHTED_SELECTIONS ) )
                //{
                //  // Note: filterSet must be non-null based on containedInFilter bool
                //  hkVdbMap_copy( *setFilterRemovedOut, setFilter );
                //  setFilter->clear();
                //  filterCleared = true;
                //}
                //else
                if ( m_selectionFlags.anyIsSet( hkgVdbSelectionFlags::IGNORE_UNHIGHLIGHTED_SELECTIONS ) )
                {
                    goto SilentlyIgnoreId;
                }
                else
                {
                    updateFilter = true;
                }
            }

            hkgDisplayObject* object = getObjectFromId( id );
            // Only allow geometry selections in geometry set and display selections in display set
            if ( ( IDX == GeometrySetIdx ) == ( object != HK_NULL ) )
            {
                set.setValue( iter, object );
                addedOut.insert( id, object );
                if ( updateFilter )
                {
                    SelectionSet::Iterator filterIter = setFilter->findOrInsertKey( id, m_dummyObj );
                    if ( setFilter->getValue( filterIter ) == m_dummyObj )
                    {
                        setFilter->setValue( filterIter, object );
                        setFilterAddedOut->insert( id, object );
                    }
                }
                continue;
            }
            else
            {
                succeeded = false;
            SilentlyIgnoreId:
                set.remove( iter );
                continue;
            }
        }
    }

    HK_VDB_VERIFY_CONDITION_MSG(
        succeeded,
        0xadb00027,
        hkVdbError::INVALID_ARGUMENTS,
        "Some of the ids were not valid for highlighting/selecting and were therefore rejected" );

    return HK_SUCCESS;
}

template<int IDX>
HK_INLINE void hkgVdbSelectionWidget::signalSelectionChangedInternal( SelectionChangedInfo& changedInfo )
{
    SelectionChangedSignal& signal = IDX == GeometrySetIdx ? static_cast< SelectionChangedSignal& >( m_geometrySelectionChanged ) : static_cast< SelectionChangedSignal& >( m_displaySelectionChanged );
    
    signal.fire( m_selectionSets[IDX], changedInfo );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
