// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Color/hkColor.h>

#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbDisplayHandler.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/3d/hkgVdb3dWidget.h>

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdbGridWidget.
//////////////////////////////////////////////////////////////////////////

struct HK_EXPORT_VDB hkgVdbGridWidgetOptions
{
    HK_DECLARE_CLASS( hkgVdbGridWidgetOptions, New );

    /// Represents a canonical axis or it's negation.
    enum UpAxis
    {
        X,
        Y,
        Z,
        NEG_X,
        NEG_Y,
        NEG_Z
    };

    hkgVdbGridWidgetOptions() :
        m_upAxis( HKG_VDB_DEFAULT_GRID_UP ),
        m_halfSpan( HKG_VDB_DEFAULT_GRID_HALF_SPAN ),
        m_numSubLines( HKG_VDB_DEFAULT_GRID_SUB_LINES ),
        m_color( 0xa0a0a0a0 ),
        m_subLineColor( 0x80808080 ),
        m_scale( 1.0f )
    {}

    /// The canonical axis which is up for the grid.
    UpAxis m_upAxis;

    /// The half span of the grid.
    hkInt32 m_halfSpan;

    /// Num of sublines across the grid.
    hkInt32 m_numSubLines;

    /// The color of the grid.
    hkColor::Argb m_color;

    /// The color of the grid sub-lines.
    hkColor::Argb m_subLineColor;

    /// The grid's scale.
    hkReal m_scale;
};

//////////////////////////////////////////////////////////////////////////
/// A widget which draws a grid in the scene
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbGridWidget : public hkgVdb3dWidget
{
public:

    HK_DECLARE_CLASS( hkgVdbGridWidget, New, ReflectIdentity );

    //
    // 3d Widget interface
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual void render( hkgDisplayContext& context ) const HK_OVERRIDE;

    //
    // Control
    //

    /// Access the current options.
    hkgVdbGridWidgetOptions& accessOptions() { return m_options; }

    //
    // Internal use
    //

    void onDisplayOptionsSetSignal( const hkDebugDisplayHandler::Options& options, hkVdbSignalResult& result );

protected:

    hkgVdbGridWidgetOptions m_options;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
